/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.sql.Time;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.nakedobjects.applib.value.TestClock;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapterTestCase;
import org.nakedobjects.nof.core.adapter.value.TimeAdapter;

public class TimeAdapterTest
extends AbstractValueAdapterTestCase {
    private Time twoOClock;
    private TimeAdapter value;

    protected void setUp() throws Exception {
        super.setUp();
        Locale.setDefault(Locale.US);
        TimeZone.setDefault(TestClock.timeZone);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TestClock.timeZone);
        c.set(14, 0);
        c.set(1, 0);
        c.set(2, 0);
        c.set(5, 0);
        c.set(11, 14);
        c.set(12, 0);
        c.set(13, 0);
        this.twoOClock = new Time(c.getTimeInMillis());
        this.value = new TimeAdapter(this.twoOClock);
        ((AbstractValueAdapterTestCase)this).value = this.value;
    }

    public void testNewEmptyTime() {
        TimeAdapter adapter = new TimeAdapter();
        TimeAdapterTest.assertTrue((boolean)adapter.isEmpty());
        TimeAdapterTest.assertEquals((String)"NULL", (String)adapter.asEncodedString());
    }

    public void testNewTime() {
        TimeAdapterTest.assertEquals((String)"140000000", (String)this.value.asEncodedString());
    }

    public void testAdd() {
        TimeAdapter adapter = new TimeAdapter(this.twoOClock);
        adapter.add(0, 0, 0, 1, 15);
        TimeAdapterTest.assertEquals((String)"151500000", (String)adapter.asEncodedString());
    }

    public void testAdd2() {
        TimeAdapter adapter = new TimeAdapter(this.twoOClock);
        adapter.add(0, 0, 0, 0, 0);
        TimeAdapterTest.assertEquals((String)"140000000", (String)adapter.asEncodedString());
    }
}

