/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.conf;

import junit.framework.TestCase;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.conf.DefaultConfigurationLoader;
import org.nakedobjects.nof.core.util.NakedObjectConfiguration;

public class DefaultConfigurationLoaderTest
extends TestCase {
    DefaultConfigurationLoader loader;

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.loader = new DefaultConfigurationLoader("src/test/config");
    }

    public void testDefaultConfiguration() {
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)"one", (String)configuration.getString("properties.example"));
    }

    public void testAddConfiguration() {
        this.loader.addConfigurationFile("another.properties", true);
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)"added", (String)configuration.getString("additional.example"));
    }

    public void testAddedConfigurationOveridesEarlierProperties() {
        this.loader.addConfigurationFile("another.properties", true);
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)"two", (String)configuration.getString("properties.example"));
    }

    public void testAddedConfigurationFailsWhenFileNotFound() {
        try {
            this.loader.addConfigurationFile("unfound.properties", true);
            DefaultConfigurationLoaderTest.fail();
        }
        catch (NakedObjectRuntimeException nakedObjectRuntimeException) {
            // empty catch block
        }
    }

    public void testAddedConfigurationIgnoreUnfoundFile() {
        this.loader.addConfigurationFile("unfound.properties", false);
    }

    public void testAddProperty() throws Exception {
        this.loader.add("added.property", "added by code");
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)"added by code", (String)configuration.getString("added.property"));
    }

    public void testIncludeSystemProperty() throws Exception {
        this.loader.setIncludeSystemProperties(true);
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)System.getProperty("os.name"), (String)configuration.getString("os.name"));
    }

    public void testAddConfigurationInDifferentDirectory() throws Exception {
        this.loader.addConfigurationFile("src/test", "three.properties", true);
        NakedObjectConfiguration configuration = this.loader.load();
        DefaultConfigurationLoaderTest.assertEquals((String)"version 3", (String)configuration.getString("different.property"));
    }
}

