/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.persist;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.nof.core.persist.SerialOid;

public class SerialOidTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(SerialOidTest.class);
    }

    public void testEquals() {
        SerialOid oid1 = SerialOid.createTransient((long)123L);
        SerialOid oid2 = SerialOid.createTransient((long)123L);
        SerialOid oid3 = SerialOid.createTransient((long)321L);
        SerialOid oid4 = SerialOid.createPersistent((long)321L);
        SerialOid oid5 = SerialOid.createPersistent((long)456L);
        SerialOid oid6 = SerialOid.createPersistent((long)456L);
        SerialOidTest.assertTrue((boolean)oid1.equals(oid2));
        SerialOidTest.assertTrue((boolean)oid2.equals(oid1));
        SerialOidTest.assertFalse((boolean)oid1.equals(oid3));
        SerialOidTest.assertFalse((boolean)oid3.equals(oid1));
        SerialOidTest.assertTrue((boolean)oid5.equals(oid6));
        SerialOidTest.assertTrue((boolean)oid6.equals(oid5));
        SerialOidTest.assertFalse((boolean)oid4.equals(oid5));
        SerialOidTest.assertFalse((boolean)oid5.equals(oid4));
        SerialOidTest.assertFalse((boolean)oid3.equals((Object)oid4));
        SerialOidTest.assertFalse((boolean)oid4.equals((Object)oid3));
        SerialOidTest.assertFalse((boolean)oid3.equals(oid4));
        SerialOidTest.assertFalse((boolean)oid4.equals(oid3));
    }

    public void testHashCode() {
        SerialOid oid1 = SerialOid.createTransient((long)123L);
        SerialOid oid2 = SerialOid.createTransient((long)123L);
        SerialOid oid3 = SerialOid.createTransient((long)321L);
        SerialOid oid4 = SerialOid.createPersistent((long)321L);
        SerialOid oid5 = SerialOid.createPersistent((long)456L);
        SerialOid oid6 = SerialOid.createPersistent((long)456L);
        SerialOidTest.assertEquals((int)oid1.hashCode(), (int)oid2.hashCode());
        SerialOidTest.assertFalse((oid1.hashCode() == oid3.hashCode() ? 1 : 0) != 0);
        SerialOidTest.assertEquals((int)oid5.hashCode(), (int)oid6.hashCode());
        SerialOidTest.assertFalse((oid4.hashCode() == oid5.hashCode() ? 1 : 0) != 0);
        SerialOidTest.assertFalse((oid3.hashCode() == oid4.hashCode() ? 1 : 0) != 0);
    }

    public void testCopy() {
        SerialOid oid1 = SerialOid.createTransient((long)123L);
        SerialOid oid3 = SerialOid.createTransient((long)321L);
        SerialOidTest.assertFalse((oid1.hashCode() == oid3.hashCode() ? 1 : 0) != 0);
        oid1.copyFrom((Oid)oid3);
        SerialOidTest.assertEquals((int)oid1.hashCode(), (int)oid3.hashCode());
    }

    public void testStringAsHex() {
        SerialOidTest.assertEquals((String)"TOID#7B", (String)SerialOid.createTransient((long)123L).toString());
        SerialOidTest.assertEquals((String)"OID#80", (String)SerialOid.createPersistent((long)128L).toString());
    }

    public void testMakePersistent() {
        SerialOid oid1 = SerialOid.createTransient((long)123L);
        SerialOidTest.assertNull((Object)oid1.getPrevious());
        oid1.makePersistent(567L);
        SerialOidTest.assertEquals((long)567L, (long)oid1.getSerialNo());
        SerialOidTest.assertEquals((boolean)false, (boolean)oid1.isTransient());
        SerialOidTest.assertEquals((Object)oid1.getPrevious(), (Object)SerialOid.createTransient((long)123L));
    }
}

