/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.testsystem;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.reflect.SpecObjectPair;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.value.IntAdapter;
import org.nakedobjects.nof.core.adapter.value.StringAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.UnexpectedCallException;
import org.nakedobjects.nof.testsystem.TestProxyException;
import org.nakedobjects.nof.testsystem.TestProxyNakedCollection;
import org.nakedobjects.nof.testsystem.TestProxyNakedObject;
import org.nakedobjects.nof.testsystem.TestProxyOid;
import org.nakedobjects.nof.testsystem.TestProxySpecification;
import org.nakedobjects.testing.TestValueAdapter;

public class TestProxyObjectLoader
implements NakedObjectLoader {
    private static int oidSerialNumber = -1;
    private Hashtable identites = new Hashtable();
    private Hashtable objectAdapters = new Hashtable();
    private Hashtable collectionAdapters = new Hashtable();
    private Hashtable recreatedPersistent = new Hashtable();
    private Vector recreatedTransient = new Vector();
    private Hashtable valueAdapters = new Hashtable();

    public void addAdapter(Object object, NakedCollection collection) {
        this.collectionAdapters.put(object, collection);
    }

    public void addAdapter(Object object, NakedObject nakedobject) {
        this.objectAdapters.put(object, nakedobject);
    }

    public void addAdapter(Object object, NakedValue value) {
        this.valueAdapters.put(object, value);
    }

    public void addIdentity(Oid oid, NakedReference adapter) {
        this.identites.put(oid, adapter);
    }

    public void addRecreated(Oid oid, NakedReference adapter) {
        this.recreatedPersistent.put(oid, adapter);
    }

    public void addRecreatedTransient(NakedReference adapter) {
        this.recreatedTransient.addElement(adapter);
    }

    public NakedCollection createAdapterForCollection(Object collection, NakedObjectSpecification specification) {
        TestProxyNakedCollection adapter = new TestProxyNakedCollection(collection);
        this.collectionAdapters.put(collection, adapter);
        return adapter;
    }

    public NakedObject createAdapterForTransient(Object object) {
        return this.createAdapterForTransient(object, true);
    }

    public NakedObject createAdapterForTransient(Object object, boolean defaultProperties) {
        Assert.assertNotNull((String)"pojo must be specified", (Object)object);
        TestProxyNakedObject adapter = new TestProxyNakedObject();
        adapter.setupObject(object);
        adapter.setupResolveState(ResolveState.TRANSIENT);
        TestProxyOid oid = new TestProxyOid(oidSerialNumber--);
        adapter.setupOid(oid);
        NakedObjectSpecification spec = NakedObjectsContext.getReflector().loadSpecification(object.getClass());
        adapter.setupSpecification(spec);
        this.addAdapter(object, adapter);
        this.addIdentity(oid, (NakedReference)adapter);
        return adapter;
    }

    public NakedValue createAdapterForValue(Object value) {
        if (value instanceof Integer) {
            return new IntAdapter((Integer)value);
        }
        if (value instanceof String) {
            return new StringAdapter((String)value);
        }
        throw new IllegalArgumentException("Can't create adapter for value " + value);
    }

    public NakedObject createTransientInstance(NakedObjectSpecification specification) {
        throw new NakedObjectRuntimeException();
    }

    public NakedValue createValueInstance(NakedObjectSpecification specification) {
        return new TestValueAdapter();
    }

    public void debugData(DebugString debug) {
        throw new NakedObjectRuntimeException();
    }

    public String debugTitle() {
        throw new NakedObjectRuntimeException();
    }

    public void end(NakedReference object) {
        ResolveState finalState = object.getResolveState().getEndState();
        ((TestProxyNakedObject)object).setupResolveState(finalState);
    }

    public NakedObject getAdapterFor(Object object) {
        return (NakedObject)this.objectAdapters.get(object);
    }

    public NakedObject getAdapterFor(Oid oid) {
        this.processChangedOid(oid);
        NakedObject no = (NakedObject)this.identites.get(oid);
        return no;
    }

    public NakedCollection getAdapterForElseCreateAdapterForCollection(NakedObject parent, String fieldName, NakedObjectSpecification elementSpecification, Object collection) {
        if (this.collectionAdapters.contains(collection)) {
            return (NakedCollection)this.collectionAdapters.get(collection);
        }
        return this.createAdapterForCollection(collection, elementSpecification);
    }

    public NakedObject getAdapterForElseCreateAdapterForTransient(Object object) {
        NakedObject adapter = (NakedObject)this.objectAdapters.get(object);
        if (adapter == null) {
            return this.createAdapterForTransient(object);
        }
        return adapter;
    }

    public Naked[] getAdapters(SpecObjectPair[] pairs) {
        throw new NakedObjectRuntimeException("Not implemented in TestObjectLoader");
    }

    public Naked getAdapter(SpecObjectPair pair) {
        throw new NakedObjectRuntimeException("Not implemented in TestObjectLoader");
    }

    public void addAdapterClass(Class valueClass, Class adapterClass) {
        throw new NakedObjectRuntimeException("Not implemented in TestObjectLoader");
    }

    public Object[] getServices() {
        throw new UnexpectedCallException();
    }

    public Enumeration getIdentifiedObjects() {
        throw new NakedObjectRuntimeException();
    }

    public void init() {
    }

    public void initDomainObject(Object domainObject) {
    }

    public boolean isIdentityKnown(Oid oid) {
        return this.identites.containsKey(oid);
    }

    public void madePersistent(NakedReference adapter) {
        Oid oid = adapter.getOid();
        this.identites.remove(oid);
        NakedObjectsContext.getObjectPersistor().convertTransientToPersistentOid(oid);
        Assert.assertTrue((String)"Adapter's pojo should exist in pojo map and return the adapter", (this.objectAdapters.get(adapter.getObject()) == adapter ? 1 : 0) != 0);
        Assert.assertNull((String)("Changed OID should not already map to a known adapter " + oid), this.identites.get(oid));
        this.identites.put(oid, adapter);
        adapter.changeState(ResolveState.RESOLVED);
    }

    private void processChangedOid(Oid oid) {
        Oid previous;
        NakedObject object;
        Assert.assertNotNull((String)"No OID", (Object)oid);
        if (oid.hasPrevious() && (object = (NakedObject)this.identites.get(previous = oid.getPrevious())) != null) {
            this.identites.remove(previous);
            Oid oidFromObject = object.getOid();
            oidFromObject.copyFrom(oid);
            this.identites.put(oidFromObject, object);
        }
    }

    public NakedObject recreateAdapterForPersistent(Oid oid, NakedObjectSpecification spec) {
        TestProxyNakedObject adapter = new TestProxyNakedObject();
        adapter.setupOid(oid);
        adapter.setupResolveState(ResolveState.GHOST);
        Object pojo = ((TestProxySpecification)spec).newInstance();
        adapter.setupObject(pojo);
        adapter.setupSpecification(spec);
        this.addAdapter(pojo, adapter);
        this.addIdentity(oid, (NakedReference)adapter);
        return adapter;
    }

    public NakedObject recreateAdapter(Oid oid, Object pojo) {
        if (this.isIdentityKnown(oid)) {
            return this.getAdapterFor(oid);
        }
        TestProxyNakedObject adapter = new TestProxyNakedObject();
        adapter.setupOid(oid);
        adapter.setupResolveState(oid.isTransient() ? ResolveState.TRANSIENT : ResolveState.GHOST);
        adapter.setupObject(pojo);
        NakedObjectSpecification spec = NakedObjectsContext.getReflector().loadSpecification(pojo.getClass());
        adapter.setupSpecification(spec);
        this.addAdapter(pojo, adapter);
        this.addIdentity(oid, (NakedReference)adapter);
        return adapter;
    }

    public NakedCollection recreateCollection(NakedObjectSpecification collectionSpecification, NakedObjectSpecification elementSpecification) {
        return new TestProxyNakedCollection();
    }

    public NakedObject recreateTransientInstance(Oid oid, NakedObjectSpecification spec) {
        TestProxyNakedObject adapter = new TestProxyNakedObject();
        adapter.setupOid(oid);
        adapter.setupResolveState(ResolveState.TRANSIENT);
        Object pojo = ((TestProxySpecification)spec).newInstance();
        adapter.setupObject(pojo);
        adapter.setupSpecification(spec);
        this.addAdapter(pojo, adapter);
        this.addIdentity(oid, (NakedReference)adapter);
        return adapter;
    }

    public void reset() {
        this.identites.clear();
        this.objectAdapters.clear();
        this.recreatedPersistent.clear();
        this.recreatedTransient.clear();
        this.valueAdapters.clear();
    }

    public void setServices(Object[] services) {
    }

    public void shutdown() {
    }

    public void start(NakedReference object, ResolveState targetState) {
        if (!object.getResolveState().isValidToChangeTo(targetState)) {
            throw new TestProxyException("Not valid to change from " + object.getResolveState() + " to " + targetState);
        }
        ((TestProxyNakedObject)object).setupResolveState(targetState);
    }

    public void unloaded(NakedObject object) {
        throw new NakedObjectRuntimeException();
    }
}

