/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.testsystem;

import java.util.Hashtable;
import java.util.Vector;
import junit.framework.Assert;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.adapter.Version;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.persist.ObjectPersistenceException;
import org.nakedobjects.noa.persist.UnsupportedFindException;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.persist.OidGenerator;
import org.nakedobjects.nof.core.util.NotImplementedException;
import org.nakedobjects.nof.testsystem.TestProxyException;
import org.nakedobjects.nof.testsystem.TestProxyOidGenerator;
import org.nakedobjects.nof.testsystem.TestProxyVersion;
import test.org.nakedobjects.object.MockNakedObject;

public class TestProxyPersistor
implements NakedObjectPersistor {
    private Vector actions = new Vector();
    private Hashtable objects = new Hashtable();
    private OidGenerator generator = new TestProxyOidGenerator();

    public static TestProxyPersistor setup() {
        TestProxyPersistor persistor = new TestProxyPersistor();
        persistor.reset();
        return persistor;
    }

    public void abortTransaction() {
    }

    public void assertAction(int i, String action) {
        if (i >= this.actions.size()) {
            Assert.fail((String)("No such action " + action));
        }
        Assert.assertEquals((Object)action, this.actions.elementAt(i));
    }

    protected void createClass(NakedObjectSpecification nc) throws ObjectPersistenceException {
    }

    public void destroyObject(NakedObject object) {
        this.actions.addElement("object deleted " + object.getOid());
    }

    public void endTransaction() {
        this.actions.addElement("end transaction");
    }

    protected NakedObject[] getInstances(InstancesCriteria criteria) {
        return null;
    }

    public NakedObject[] getInstances(NakedObjectSpecification cls, boolean includeSubclasses) {
        return new NakedObject[]{new MockNakedObject(), new MockNakedObject()};
    }

    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) {
        if (NakedObjectsContext.getObjectLoader().isIdentityKnown(oid)) {
            return NakedObjectsContext.getObjectLoader().getAdapterFor(oid);
        }
        NakedObject nakedObject = (NakedObject)this.objects.get(oid);
        if (nakedObject == null) {
            throw new TestProxyException("No persisted object to get for " + oid);
        }
        return nakedObject;
    }

    public Oid getOidForService(String name) {
        return null;
    }

    public boolean hasInstances(NakedObjectSpecification cls, boolean includeSubclasses) {
        throw new NotImplementedException();
    }

    public boolean isInitialized() {
        return true;
    }

    public void init() {
    }

    public void makePersistent(NakedObject object) {
        object.setOptimisticLock((Version)new TestProxyVersion(1));
        object.changeState(ResolveState.RESOLVED);
        this.objects.put(object.getOid(), object);
    }

    public void objectChanged(NakedObject object) {
        this.actions.addElement("object changed " + object.getOid());
        object.setOptimisticLock(((TestProxyVersion)object.getVersion()).next());
    }

    public void reload(NakedObject object) {
    }

    public void reset() {
        this.actions.removeAllElements();
    }

    public void resolveField(NakedObject object, NakedObjectField field) {
    }

    public void resolveImmediately(NakedObject object) {
    }

    public void saveChanges() {
    }

    public void setupAddObject(NakedObject object) {
        this.objects.put(object.getOid(), object);
    }

    public void setServices(Object[] services) {
    }

    public void shutdown() {
    }

    public void startTransaction() {
        this.actions.addElement("start transaction");
    }

    public boolean flushTransaction() {
        this.actions.addElement("flush transaction");
        return false;
    }

    public Oid createTransientOid(Object object) {
        return this.generator.createTransientOid(object);
    }

    public void convertTransientToPersistentOid(Oid oid) {
        this.generator.convertTransientToPersistentOid(oid);
    }

    public void convertPersistentToTransientOid(Oid oid) {
        this.generator.convertPersistentToTransientOid(oid);
    }

    public NakedCollection findInstances(InstancesCriteria criteria) throws UnsupportedFindException {
        throw new NotImplementedException();
    }
}

