/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.testsystem.tests;

import junit.framework.TestCase;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.testsystem.TestPojo;
import org.nakedobjects.nof.testsystem.TestProxyNakedObject;
import org.nakedobjects.nof.testsystem.TestProxyOid;
import org.nakedobjects.nof.testsystem.TestProxySystem;
import org.nakedobjects.nof.testsystem.TestProxyVersion;

public class CreatePersistentObjectsTest
extends TestCase {
    private TestProxySystem system;
    private TestProxyNakedObject adapter;
    private TestPojo pojo;
    private Oid oid;

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.system = new TestProxySystem();
        this.system.init();
        this.pojo = new TestPojo();
        this.adapter = this.system.createPersistentTestObject(this.pojo);
        this.oid = this.adapter.getOid();
    }

    public void testStateOfCreatedAdapted() {
        CreatePersistentObjectsTest.assertNotNull((Object)this.adapter);
        CreatePersistentObjectsTest.assertEquals((Object)new TestProxyOid(90000, true), (Object)this.oid);
        CreatePersistentObjectsTest.assertEquals((Object)new TestProxyVersion(1), (Object)this.adapter.getVersion());
        CreatePersistentObjectsTest.assertEquals((Object)ResolveState.RESOLVED, (Object)this.adapter.getResolveState());
        CreatePersistentObjectsTest.assertEquals((Object)this.pojo, (Object)this.adapter.getObject());
    }

    public void testSpecification() {
        CreatePersistentObjectsTest.assertNotNull((Object)this.adapter.getSpecification());
        CreatePersistentObjectsTest.assertNotNull((String)TestPojo.class.getName(), (Object)this.adapter.getSpecification().getFullName());
    }

    public void test2ndPersistentCreationHasDifferentOid() {
        TestPojo pojo = new TestPojo();
        TestProxyNakedObject adapter2 = this.system.createPersistentTestObject(pojo);
        CreatePersistentObjectsTest.assertNotNull((Object)adapter2);
        CreatePersistentObjectsTest.assertEquals((Object)new TestProxyOid(90001, true), (Object)adapter2.getOid());
    }

    public void testIsAddedToObjectLoader() throws Exception {
        NakedObject a = NakedObjectsContext.getObjectLoader().getAdapterFor(this.oid);
        CreatePersistentObjectsTest.assertEquals((Object)this.adapter, (Object)a);
    }

    public void testAddedToPersistor() throws Exception {
        this.system.resetLoader();
        NakedObject a = NakedObjectsContext.getObjectPersistor().getObject(this.oid, null);
        CreatePersistentObjectsTest.assertEquals((Object)this.adapter, (Object)a);
    }
}

