/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.testing;

import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.StaticContext;
import org.nakedobjects.nof.core.util.NakedObjectConfiguration;
import org.nakedobjects.testing.DummyNakedObject;
import org.nakedobjects.testing.TestConfiguration;
import org.nakedobjects.testing.TestObjectLoader;
import org.nakedobjects.testing.TestPersistor;
import org.nakedobjects.testing.TestSession;
import org.nakedobjects.testing.TestSpecification;
import org.nakedobjects.testing.TestSpecificationLoader;

public class TestSystem {
    private TestConfiguration configuration;
    private NakedObjectsContext nakedObjects;
    private final TestObjectLoader objectLoader;
    private NakedObjectPersistor objectPersistor;
    private final TestSpecificationLoader specificationLoader = new TestSpecificationLoader();

    public TestSystem() {
        this.objectLoader = new TestObjectLoader();
        this.objectPersistor = new TestPersistor();
        this.configuration = new TestConfiguration();
    }

    public void addAdapterToObjectLoader(Object object, NakedObject adapter) {
        this.objectLoader.addAdapter(object, adapter);
    }

    public void addCollectionToObjectLoader(NakedCollection collection) {
        this.objectLoader.addAdapter(collection.getObject(), collection);
    }

    public void addConfigurationProperty(String name, String value) {
        this.configuration.add(name, value);
    }

    public void addIdentityToObjectLoader(Oid oid, NakedReference adapter) {
        this.objectLoader.addIdentity(oid, adapter);
    }

    public void addRecreatedAdapterToObjectLoader(Oid oid, DummyNakedObject adapter) {
        this.objectLoader.addRecreated(oid, (NakedReference)adapter);
    }

    public void addRecreatedTransientToObjectLoader(DummyNakedObject adapter) {
        this.objectLoader.addRecreatedTransient((NakedReference)adapter);
    }

    public void addSpecificationToLoader(NakedObjectSpecification specification) {
        this.specificationLoader.addSpecification(specification);
    }

    public void addSpecificationToLoader(String name) {
        this.addSpecificationToLoader(new TestSpecification(name));
    }

    public void addValueToObjectLoader(Object object, NakedValue adapter) {
        this.objectLoader.addAdapter(object, adapter);
    }

    public NakedObject createAdapterForTransient(Object associate) {
        NakedObject createAdapterForTransient = this.objectLoader.createAdapterForTransient(associate, false);
        this.objectLoader.addAdapter(associate, createAdapterForTransient);
        return createAdapterForTransient;
    }

    public void init() {
        this.nakedObjects = StaticContext.createInstance();
        NakedObjectsContext.setConfiguration((NakedObjectConfiguration)this.configuration);
        this.nakedObjects.setReflector((NakedObjectReflector)this.specificationLoader);
        this.nakedObjects.setObjectLoader((NakedObjectLoader)this.objectLoader);
        this.nakedObjects.setObjectPersistor(this.objectPersistor);
        this.nakedObjects.setSession((Session)new TestSession());
        NakedObjectsContext.getReflector().init();
        NakedObjectsContext.getObjectLoader().init();
        NakedObjectsContext.getObjectPersistor().init();
    }

    public void setObjectPersistor(NakedObjectPersistor objectPersistor) {
        this.objectPersistor = objectPersistor;
    }

    public void shutdown() {
        NakedObjectsContext.getReflector().shutdown();
        NakedObjectsContext.getObjectLoader().shutdown();
        NakedObjectsContext.getObjectPersistor().shutdown();
    }
}

