/*
 * Decompiled with CFR 0.152.
 */
package test.org.nakedobjects.utility;

import java.util.Vector;
import junit.framework.Assert;
import test.org.nakedobjects.utility.ExpectedCall;

public class ExpectedCalls {
    private Vector expectedObjects = new Vector();
    private Vector actualObjects = new Vector();

    private void assertExpectedNoMoreThanActuals() {
        Assert.assertTrue((String)("More actuals than expected; didn't expect call " + this.actualObjects.lastElement()), (this.actualObjects.size() <= this.expectedObjects.size() ? 1 : 0) != 0);
    }

    public void verify() {
        this.assertLastMethodsParametersCorrect();
        Assert.assertTrue((String)("Too few calls added\n  Expected " + this.expectedObjects), (this.actualObjects.size() == this.expectedObjects.size() ? 1 : 0) != 0);
    }

    private void assertLastMethodsParametersCorrect() {
        int lastActual = this.actualObjects.size() - 1;
        if (lastActual >= 0) {
            ExpectedCall lastExpectedCall = (ExpectedCall)this.expectedObjects.elementAt(lastActual);
            ExpectedCall lastActualCall = (ExpectedCall)this.actualObjects.elementAt(lastActual);
            int actualParameterSize = lastActualCall.paramters.size();
            int expectedParameterSize = lastExpectedCall.paramters.size();
            Assert.assertEquals((String)("Method " + lastExpectedCall.name + " parameters incorrect; "), (int)expectedParameterSize, (int)actualParameterSize);
        }
    }

    public void addExpectedMethod(String name) {
        this.expectedObjects.addElement(new ExpectedCall(name));
    }

    public void addExpectedParameter(Object value) {
        ExpectedCall expected = (ExpectedCall)this.expectedObjects.lastElement();
        expected.addParameter(value);
    }

    public void addActualMethod(String name) {
        this.assertLastMethodsParametersCorrect();
        ExpectedCall actual = new ExpectedCall(name);
        this.actualObjects.addElement(actual);
        this.assertExpectedNoMoreThanActuals();
        int element = this.actualObjects.size() - 1;
        ExpectedCall expected = (ExpectedCall)this.expectedObjects.elementAt(element);
        Assert.assertEquals((String)"Actual method does not match expected.\n", (String)expected.name, (String)name);
    }

    public void addActualParameter(Object value) {
        ExpectedCall actual = (ExpectedCall)this.actualObjects.lastElement();
        actual.addParameter(value);
        int expectedElement = this.actualObjects.size() - 1;
        ExpectedCall expectedCall = (ExpectedCall)this.expectedObjects.elementAt(expectedElement);
        int parameterElement = actual.paramters.size() - 1;
        int expectedParameterSize = expectedCall.paramters.size();
        if (parameterElement >= expectedParameterSize) {
            Assert.fail((String)("Unexpected number of parameters; expected " + expectedParameterSize + ", but got " + actual.paramters.size()));
        }
        Object expected = expectedCall.parameterAt(parameterElement);
        Assert.assertEquals((String)("Actual parameter (" + parameterElement + ") in " + expectedCall.name + " does not match expected.\n"), (Object)expected, (Object)value);
    }
}

