/*
 * Decompiled with CFR 0.152.
 */
package test.org.nakedobjects.utility;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import test.org.nakedobjects.utility.ExpectedCalls;

public class ExpectedCallsTest
extends TestCase {
    private ExpectedCalls calls;

    public static void main(String[] args) {
        TestRunner.run(ExpectedCallsTest.class);
    }

    protected void setUp() throws Exception {
        this.calls = new ExpectedCalls();
        this.calls.addExpectedMethod("testMethod4");
        this.calls.addExpectedParameter("param1");
        this.calls.addExpectedParameter("param2");
        this.calls.addExpectedParameter("param3");
        this.calls.addExpectedMethod("testMethod1");
        this.calls.addExpectedParameter("param1");
    }

    public void testNoMethodsCalled() {
        try {
            this.calls.verify();
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedCallsTest.fail();
    }

    public void testAllMethodsCalled() {
        this.calls.addActualMethod("testMethod4");
        this.calls.addActualParameter("param1");
        this.calls.addActualParameter("param2");
        this.calls.addActualParameter("param3");
        this.calls.addActualMethod("testMethod1");
        this.calls.addActualParameter("param1");
        this.calls.verify();
    }

    public void testMethodNameWrong() {
        try {
            this.calls.addActualMethod("testMethod2");
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedCallsTest.fail();
    }

    public void testMethodParameterWrong() {
        try {
            this.calls.addActualMethod("testMethod4");
            this.calls.addActualParameter("param1");
            this.calls.addActualParameter("param3");
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedCallsTest.fail();
    }

    public void testMethodWithTooManyParameters() {
        try {
            this.calls.addActualMethod("testMethod4");
            this.calls.addActualParameter("param1");
            this.calls.addActualParameter("param2");
            this.calls.addActualParameter("param3");
            this.calls.addActualParameter("param4");
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedCallsTest.fail();
    }

    public void testTooManyMethods() {
        try {
            this.calls.addActualMethod("testMethod4");
            this.calls.addActualParameter("param1");
            this.calls.addActualParameter("param2");
            this.calls.addActualParameter("param3");
            this.calls.addActualMethod("testMethod1");
            this.calls.addActualParameter("param1");
            this.calls.addActualMethod("testMethod1");
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedCallsTest.fail();
    }

    public void testTooFewMethods() {
        try {
            this.calls.addActualMethod("testMethod4");
            this.calls.addActualParameter("param1");
            this.calls.addActualParameter("param2");
            this.calls.addActualParameter("param3");
            this.calls.verify();
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedCallsTest.fail();
    }

    public void testMethodWithTooFewParametersWhenNewMethodStarted() {
        try {
            this.calls.addActualMethod("testMethod4");
            this.calls.addActualParameter("param1");
            this.calls.addActualParameter("param2");
            this.calls.addActualMethod("testMethod1");
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedCallsTest.fail();
    }

    public void testMethodWithTooFewParametersWhenVerifying() {
        try {
            this.calls.addActualMethod("testMethod4");
            this.calls.addActualParameter("param1");
            this.calls.addActualParameter("param2");
            this.calls.addActualParameter("param3");
            this.calls.addActualMethod("testMethod1");
            this.calls.verify();
        }
        catch (AssertionFailedError e) {
            return;
        }
        ExpectedCallsTest.fail();
    }
}

