/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.Persistable;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.adapter.Version;
import org.nakedobjects.noa.persist.ConcurrencyException;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.ToString;

public abstract class AbstractNakedReference
implements NakedReference {
    private static final Logger LOG = Logger.getLogger(AbstractNakedReference.class);
    private String defaultTitle;
    private Oid oid;
    private transient ResolveState resolveState = ResolveState.NEW;
    private NakedObjectSpecification specification;
    private Version version;

    public void changeState(ResolveState newState) {
        Assert.assertTrue("can't change to " + newState.name() + ": " + this, this.resolveState.isValidToChangeTo(newState));
        LOG.debug((Object)("recreate - change state " + this + " to " + newState.name()));
        this.resolveState = newState;
    }

    public void checkLock(Version version) {
        if (this.version != null && this.version.different(version)) {
            LOG.info((Object)("concurrency conflict on " + this + " (" + version + ")"));
            throw new ConcurrencyException((NakedReference)this, version);
        }
    }

    protected String getDefaultTitle() {
        return this.defaultTitle;
    }

    public String getIconName() {
        return this.getSpecification().getIconName((NakedReference)this);
    }

    public Oid getOid() {
        return this.oid;
    }

    public ResolveState getResolveState() {
        return this.resolveState;
    }

    public NakedObjectSpecification getSpecification() {
        if (this.specification == null) {
            this.specification = NakedObjectsContext.getReflector().loadSpecification(this.getObject().getClass());
            this.defaultTitle = "A" + (" " + this.specification.getSingularName()).toLowerCase();
        }
        return this.specification;
    }

    public Version getVersion() {
        return this.version;
    }

    public Persistable persistable() {
        return this.getSpecification().persistable();
    }

    protected void setOid(Oid oid) {
        if (oid == null) {
            throw new NullPointerException();
        }
        this.oid = oid;
    }

    public void setOptimisticLock(Version version) {
        if (this.shouldSetVersion(version)) {
            this.version = version;
        }
    }

    private boolean shouldSetVersion(Version version) {
        return this.version == null || version == null || version.different(this.version);
    }

    protected void toString(ToString str) {
        str.append(this.resolveState.code());
        Oid oid = this.getOid();
        if (oid != null) {
            str.append(":");
            str.append(oid.toString().toUpperCase());
        } else {
            str.append(":-");
        }
        str.setAddComma();
        if (this.specification == null) {
            str.append("class", this.getObject().getClass().getName());
        } else {
            str.append("specification", this.specification.getShortName());
        }
        str.append("version", this.version == null ? null : this.version.sequence());
    }
}

