/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter;

import java.util.Enumeration;
import java.util.Vector;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.Persistable;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.AbstractNakedReference;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.ToString;

public class InstanceCollectionVector
extends AbstractNakedReference
implements NakedCollection {
    private String name;
    private Vector instances;
    private NakedObjectSpecification instanceSpecification;

    public InstanceCollectionVector(NakedObjectSpecification elementSpecification, NakedObject[] instances) {
        this.instanceSpecification = elementSpecification;
        this.name = elementSpecification.getPluralName();
        int size = instances.length;
        this.instances = new Vector(size);
        for (int i = 0; i < size; ++i) {
            this.instances.addElement(instances[i]);
        }
    }

    public InstanceCollectionVector(NakedObjectSpecification elementSpecification, Vector instances) {
        this.instanceSpecification = elementSpecification;
        this.name = elementSpecification.getPluralName();
        int size = instances.size();
        this.instances = new Vector(size);
        for (int i = 0; i < size; ++i) {
            this.instances.addElement(instances.elementAt(i));
        }
    }

    public boolean contains(NakedObject object) {
        return false;
    }

    public Enumeration elements() {
        return this.instances.elements();
    }

    public NakedObject firstElement() {
        if (this.size() == 0) {
            return null;
        }
        NakedObject element = (NakedObject)this.instances.elementAt(0);
        return element;
    }

    public NakedObjectSpecification getElementSpecification() {
        return this.instanceSpecification;
    }

    public String getIconName() {
        return null;
    }

    public Object getObject() {
        return this.instances;
    }

    public void init(Object[] initElements) {
        Assert.assertEquals("Collection not empty", 0, this.instances.size());
        for (int i = 0; i < initElements.length; ++i) {
            this.instances.addElement(initElements[i]);
        }
    }

    public Persistable persistable() {
        return Persistable.TRANSIENT;
    }

    public void setOid(Oid oid) {
    }

    public int size() {
        return this.instances.size();
    }

    public String titleString() {
        return this.name + ", " + this.size();
    }

    public String toString() {
        String title;
        ToString s = new ToString(this);
        this.toString(s);
        s.append("elements", this.instanceSpecification.getFullName());
        try {
            title = "'" + this.titleString() + "'";
        }
        catch (NullPointerException e) {
            title = "none";
        }
        s.append("title", title);
        s.append("vector", this.instances);
        return s.toString();
    }
}

