/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.reflect.NakedObjectActionInstance;
import org.nakedobjects.noa.reflect.NakedObjectActionInstanceImpl;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.noa.reflect.OneToManyAssociationInstance;
import org.nakedobjects.noa.reflect.OneToManyAssociationInstanceImpl;
import org.nakedobjects.noa.reflect.OneToOneAssociation;
import org.nakedobjects.noa.reflect.OneToOneAssociationInstance;
import org.nakedobjects.noa.reflect.OneToOneAssociationInstanceImpl;
import org.nakedobjects.noa.reflect.ValueAssociation;
import org.nakedobjects.noa.reflect.ValueAssociationInstance;
import org.nakedobjects.noa.reflect.ValueAssociationInstanceImpl;
import org.nakedobjects.noa.reflect.listeners.ObjectEvent;
import org.nakedobjects.noa.reflect.listeners.ObjectListener;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.AbstractNakedReference;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.ToString;

public class PojoAdapter
extends AbstractNakedReference
implements NakedObject {
    private static final Logger LOG = Logger.getLogger(PojoAdapter.class);
    private Object pojo;
    private Map actionInstancesByType = new HashMap();
    private OneToManyAssociationInstance[] oneToManyAssociationInstances;
    private OneToOneAssociationInstance[] oneToOneAssociationInstances;
    private ValueAssociationInstance[] valueAssociationInstances;
    private List listeners = new ArrayList();

    public PojoAdapter(Object pojo, Oid oid) {
        this.pojo = pojo;
        this.setOid(oid);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.debug((Object)("finalizing pojo: " + this.pojo));
    }

    public Object getObject() {
        return this.pojo;
    }

    public String titleString() {
        ResolveState resolveState;
        if (this.getOid() == null) {
            throw new NakedObjectRuntimeException("OID not initialised");
        }
        NakedObjectSpecification specification = this.getSpecification();
        String title = specification.getTitle((NakedObject)this);
        if (title == null && (resolveState = this.getResolveState()).isGhost()) {
            LOG.info((Object)("attempting to use unresolved object; resolving it immediately: " + this));
            NakedObjectsContext.getObjectPersistor().resolveImmediately((NakedObject)this);
        }
        if (title == null) {
            title = this.getDefaultTitle();
        }
        return title;
    }

    public synchronized String toString() {
        ToString str = new ToString(this);
        this.toString(str);
        ResolveState resolveState = this.getResolveState();
        if (resolveState.isTransient() || resolveState.isResolved()) {
            str.append("title", this.titleString());
        }
        str.appendAsHex("pojo-hash", this.pojo.hashCode());
        return str.toString();
    }

    public NakedObjectActionInstance[] getActionInstances(NakedObjectAction.Type type) {
        NakedObjectActionInstance[] actionInstances = (NakedObjectActionInstance[])this.actionInstancesByType.get(type);
        if (actionInstances == null) {
            Vector objectActionList = new Vector();
            this.appendToActionList(this.getSpecification().getObjectActions(type), objectActionList);
            actionInstances = this.toArray(objectActionList);
            this.actionInstancesByType.put(type, actionInstances);
        }
        return actionInstances;
    }

    private void appendToActionList(NakedObjectAction[] nakedObjectActions, Vector objectActionList) {
        for (int i = 0; i < nakedObjectActions.length; ++i) {
            NakedObjectAction noa = nakedObjectActions[i];
            NakedObjectAction[] subActions = noa.getActions();
            if (subActions.length > 0) {
                this.appendToActionList(subActions, objectActionList);
                continue;
            }
            objectActionList.add(noa);
        }
    }

    private NakedObjectActionInstance[] toArray(Vector objectActionList) {
        NakedObjectActionInstance[] objectActions = new NakedObjectActionInstance[objectActionList.size()];
        Enumeration actionEnum = objectActionList.elements();
        int i = 0;
        while (actionEnum.hasMoreElements()) {
            NakedObjectAction noa = (NakedObjectAction)actionEnum.nextElement();
            objectActions[i++] = new NakedObjectActionInstanceImpl((NakedObject)this, noa);
        }
        return objectActions;
    }

    public NakedObjectActionInstance getActionInstance(NakedObjectAction action) {
        NakedObjectActionInstance[] actionInstances = this.getActionInstances(action.getType());
        for (int i = 0; i < actionInstances.length; ++i) {
            if (!actionInstances[i].getNakedObjectAction().getId().equals(action.getId())) continue;
            return actionInstances[i];
        }
        return null;
    }

    public OneToManyAssociationInstance[] getOneToManyAssociationInstances() {
        if (this.oneToManyAssociationInstances == null) {
            NakedObjectField[] fields = this.getSpecification().getFields(NakedObjectField.COLLECTIONS);
            this.oneToManyAssociationInstances = new OneToManyAssociationInstance[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                this.oneToManyAssociationInstances[i] = new OneToManyAssociationInstanceImpl((NakedObject)this, (OneToManyAssociation)fields[i]);
            }
        }
        return this.oneToManyAssociationInstances;
    }

    public OneToManyAssociationInstance getOneToManyAssociation(OneToManyAssociation field) {
        OneToManyAssociationInstance[] oneToManyAssociationInstances = this.getOneToManyAssociationInstances();
        for (int i = 0; i < oneToManyAssociationInstances.length; ++i) {
            if (oneToManyAssociationInstances[i].getOneToManyAssociation() != field) continue;
            return oneToManyAssociationInstances[i];
        }
        return null;
    }

    public OneToOneAssociationInstance[] getOneToOneAssociationInstances() {
        if (this.oneToOneAssociationInstances == null) {
            NakedObjectField[] fields = this.getSpecification().getFields(NakedObjectField.REFERENCES);
            this.oneToOneAssociationInstances = new OneToOneAssociationInstance[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                this.oneToOneAssociationInstances[i] = new OneToOneAssociationInstanceImpl((NakedObject)this, (OneToOneAssociation)fields[i]);
            }
        }
        return this.oneToOneAssociationInstances;
    }

    public OneToOneAssociationInstance getOneToOneAssociation(OneToOneAssociation field) {
        OneToOneAssociationInstance[] oneToOneAssociationInstances = this.getOneToOneAssociationInstances();
        for (int i = 0; i < oneToOneAssociationInstances.length; ++i) {
            if (oneToOneAssociationInstances[i].getOneToOneAssociation() != field) continue;
            return oneToOneAssociationInstances[i];
        }
        return null;
    }

    public ValueAssociationInstance[] getValueAssociationInstances() {
        if (this.valueAssociationInstances == null) {
            NakedObjectField[] fields = this.getSpecification().getFields(NakedObjectField.VALUES);
            this.valueAssociationInstances = new ValueAssociationInstance[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                this.valueAssociationInstances[i] = new ValueAssociationInstanceImpl((NakedObject)this, (ValueAssociation)fields[i]);
            }
        }
        return this.valueAssociationInstances;
    }

    public ValueAssociationInstance getValueAssociation(ValueAssociation field) {
        ValueAssociationInstance[] valueAssociationInstances = this.getValueAssociationInstances();
        for (int i = 0; i < valueAssociationInstances.length; ++i) {
            if (!valueAssociationInstances[i].getValueAssociation().getId().equals(field.getId())) continue;
            return valueAssociationInstances[i];
        }
        return null;
    }

    public void addObjectListener(ObjectListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeObjectListener(ObjectListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChangedEvent() {
        ObjectEvent e = new ObjectEvent((Object)this);
        ArrayList list = new ArrayList(this.listeners);
        for (ObjectListener l : list) {
            l.objectChanged(e);
        }
    }

    private void fireInvalidEvent(String reason) {
        ObjectEvent e = new ObjectEvent((Object)this, reason);
        ArrayList list = new ArrayList(this.listeners);
        for (ObjectListener l : list) {
            l.objectInvalid(e);
        }
    }

    private void fireValidEvent() {
        ObjectEvent e = new ObjectEvent((Object)this);
        ArrayList list = new ArrayList(this.listeners);
        for (ObjectListener l : list) {
            l.objectValid(e);
        }
    }
}

