/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter;

import java.util.Date;
import org.nakedobjects.noa.adapter.Version;
import org.nakedobjects.noa.util.ByteDecoder;
import org.nakedobjects.noa.util.ByteEncoder;
import org.nakedobjects.noa.util.Encodable;
import org.nakedobjects.nof.core.adapter.AbstractVersion;
import org.nakedobjects.nof.core.util.ToString;

public class SerialNumberVersion
extends AbstractVersion
implements Encodable {
    private final long versionNumber;

    public SerialNumberVersion(long number, String user, Date time) {
        super(user, time);
        this.versionNumber = number;
    }

    public SerialNumberVersion(ByteDecoder decoder) {
        super(decoder.getString(), new Date(decoder.getLong()));
        this.versionNumber = decoder.getLong();
    }

    public void encode(ByteEncoder encoder) {
        encoder.add(this.user);
        encoder.add(this.time.getTime());
        encoder.add(this.versionNumber);
    }

    public boolean different(Version version) {
        if (version instanceof SerialNumberVersion) {
            SerialNumberVersion other = (SerialNumberVersion)version;
            return this.versionNumber != other.versionNumber;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SerialNumberVersion) {
            return !this.different((SerialNumberVersion)obj);
        }
        return false;
    }

    public long getSequence() {
        return this.versionNumber;
    }

    public int hashCode() {
        return (int)(this.versionNumber ^ this.versionNumber >>> 32);
    }

    protected AbstractVersion next() {
        return new SerialNumberVersion(this.versionNumber + 1L, null, null);
    }

    public String sequence() {
        return Long.toString(this.versionNumber, 16);
    }

    public String toString() {
        return "SerialNumberVersion#" + this.versionNumber + " " + ToString.timestamp(this.time);
    }
}

