/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.map;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.nof.core.adapter.map.IdentityAdapterMap;
import org.nakedobjects.nof.core.util.DebugString;

public class IdentityAdapterHashMap
implements IdentityAdapterMap {
    private static final Logger LOG = Logger.getLogger(IdentityAdapterHashMap.class);
    private Hashtable adapters;

    public IdentityAdapterHashMap() {
        this(1000);
    }

    public IdentityAdapterHashMap(int capacity) {
        this.adapters = new Hashtable(capacity);
    }

    public void add(Oid oid, NakedReference adapter) {
        LOG.debug((Object)("add " + oid + " as " + adapter));
        this.adapters.put(oid, adapter);
    }

    public void debugData(DebugString debug) {
        Enumeration e = this.oids();
        int count = 0;
        while (e.hasMoreElements()) {
            Oid oid = (Oid)e.nextElement();
            NakedObject object = this.getAdapter(oid);
            debug.append(count++, 5);
            debug.append(" '");
            debug.append(oid.toString(), 25);
            debug.append("'    ");
            debug.appendln(object.toString());
        }
    }

    public NakedObject getAdapter(Oid oid) {
        return (NakedObject)this.adapters.get(oid);
    }

    public String debugTitle() {
        return "Identity adapter map";
    }

    public boolean isIdentityKnown(Oid oid) {
        return this.adapters.containsKey(oid);
    }

    public Enumeration oids() {
        return this.adapters.keys();
    }

    public void remove(Oid oid) {
        LOG.debug((Object)("remove " + oid));
        this.adapters.remove(oid);
    }

    public void reset() {
        LOG.debug((Object)"reset");
        this.adapters.clear();
    }

    public void shutdown() {
        LOG.debug((Object)"shutdown");
        this.adapters.clear();
    }
}

