/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.map;

import java.awt.Image;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.adapter.ObjectLoaderException;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.noa.reflect.SpecObjectPair;
import org.nakedobjects.noa.spec.NakedCollectionSpecification;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.adapter.PojoAdapter;
import org.nakedobjects.nof.core.adapter.map.IdentityAdapterHashMap;
import org.nakedobjects.nof.core.adapter.map.IdentityAdapterMap;
import org.nakedobjects.nof.core.adapter.map.InternalCollectionKey;
import org.nakedobjects.nof.core.adapter.map.PojoAdapterHashMap;
import org.nakedobjects.nof.core.adapter.map.PojoAdapterMap;
import org.nakedobjects.nof.core.adapter.value.BigDecimalAdapter;
import org.nakedobjects.nof.core.adapter.value.BigIntegerAdapter;
import org.nakedobjects.nof.core.adapter.value.BooleanAdapter;
import org.nakedobjects.nof.core.adapter.value.ByteAdapter;
import org.nakedobjects.nof.core.adapter.value.CharAdapter;
import org.nakedobjects.nof.core.adapter.value.DateAdapter;
import org.nakedobjects.nof.core.adapter.value.DateTimeAdapter;
import org.nakedobjects.nof.core.adapter.value.DoubleAdapter;
import org.nakedobjects.nof.core.adapter.value.FloatAdapter;
import org.nakedobjects.nof.core.adapter.value.ImageAdapter;
import org.nakedobjects.nof.core.adapter.value.IntAdapter;
import org.nakedobjects.nof.core.adapter.value.LongAdapter;
import org.nakedobjects.nof.core.adapter.value.ShortAdapter;
import org.nakedobjects.nof.core.adapter.value.StringAdapter;
import org.nakedobjects.nof.core.adapter.value.TimeAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nof.core.util.UnknownTypeException;

public abstract class ObjectLoaderImpl
implements NakedObjectLoader,
DebugInfo {
    private static final Logger LOG = Logger.getLogger(ObjectLoaderImpl.class);
    protected PojoAdapterMap pojoAdapterMap;
    protected IdentityAdapterMap identityAdapterMap;
    private final Hashtable adapterClasses = new Hashtable();
    private Object[] services = new Object[0];

    public NakedObject createAdapterForTransient(Object object) {
        return this.createAdapterForTransient(object, true);
    }

    public NakedObject createAdapterForTransient(Object object, boolean defaultProperties) {
        Oid transientOid = NakedObjectsContext.getObjectPersistor().createTransientOid(object);
        PojoAdapter adapter = (PojoAdapter)this.createObjectAdapter(transientOid, object);
        LOG.debug((Object)("creating adapter (transient) " + adapter));
        Assert.assertEquals(adapter, this.pojoAdapterMap.getPojo(object));
        if (defaultProperties) {
            NakedObjectField[] fields = adapter.getSpecification().getFields();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].toDefault((NakedObject)adapter);
            }
            adapter.getSpecification().lifecycleEvent((NakedObject)adapter, 0);
        }
        adapter.changeState(ResolveState.TRANSIENT);
        return adapter;
    }

    public NakedValue createAdapterForValue(NakedObjectSpecification specification) {
        Class adapterClass = (Class)this.adapterClasses.get(specification);
        NakedValue adapter = adapterClass != null ? (NakedValue)this.createInstance(adapterClass) : NakedObjectsContext.getReflector().createValueAdapter(specification);
        return adapter;
    }

    private Object createInstance(Class adapterClass) {
        try {
            return adapterClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ObjectLoaderException("Failed to create instance of type " + adapterClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectLoaderException("Failed to create instance of type " + adapterClass.getName() + "; could not access constructor", (Throwable)e);
        }
    }

    public void addAdapterClass(Class valueClass, Class adapterClass) {
        NakedObjectSpecification valueSpecification = NakedObjectsContext.getReflector().loadSpecification(valueClass);
        this.adapterClasses.put(valueSpecification, adapterClass);
    }

    public NakedValue createAdapterForValue(Object value) {
        NakedValue adapter;
        block8: {
            Assert.assertFalse("can't create an adapter for a NOF adapter", value instanceof Naked);
            Assert.assertFalse("can't create an adapter for a NO Specification", value instanceof NakedObjectSpecification);
            adapter = null;
            NakedObjectReflector reflector = NakedObjectsContext.getReflector();
            NakedObjectSpecification specification = reflector.loadSpecification(value.getClass());
            Class adapterClass = (Class)this.adapterClasses.get(specification);
            if (adapterClass != null) {
                try {
                    Constructor<?>[] constructors = adapterClass.getConstructors();
                    for (int i = 0; i < constructors.length; ++i) {
                        if (constructors[i].getParameterTypes().length != 1) continue;
                        adapter = (NakedValue)constructors[i].newInstance(value);
                        break;
                    }
                    if (adapter == null) {
                        throw new ObjectLoaderException("Failed to find suitable constructor in " + adapterClass);
                    }
                    break block8;
                }
                catch (InstantiationException e) {
                    throw new ObjectLoaderException("Failed to create value adapter of type " + adapterClass, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ObjectLoaderException("Failed to create value adapter of type " + adapterClass + "; could not access constructor", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw new ObjectLoaderException("Failed to create value adapter of type " + adapterClass, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new ObjectLoaderException("Failed to create value adapter of type " + adapterClass, (Throwable)e);
                }
            }
            adapter = reflector.createValueAdapter(value);
        }
        return adapter;
    }

    public NakedCollection createAdapterForCollection(Object collection, NakedObjectSpecification specification) {
        Assert.assertFalse("Can't create an adapter for a NOF adapter", collection instanceof Naked);
        LOG.debug((Object)("creating adapter (collection) for " + collection));
        NakedCollection adapter = NakedObjectsContext.getReflector().createCollectionAdapter(collection, specification);
        if (adapter != null) {
            this.pojoAdapterMap.add(collection, (Naked)adapter);
            LOG.debug((Object)("created " + adapter + " for " + collection));
            adapter.changeState(ResolveState.TRANSIENT);
            Assert.assertNotNull(adapter);
        }
        return adapter;
    }

    private Class classFor(NakedObjectSpecification specification) {
        Class<?> cls;
        String className = specification.getFullName();
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (className.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (className.equals("char")) {
                return Character.TYPE;
            }
            if (className.equals("byte")) {
                return Byte.TYPE;
            }
            if (className.equals("short")) {
                return Short.TYPE;
            }
            if (className.equals("int")) {
                return Integer.TYPE;
            }
            if (className.equals("long")) {
                return Long.TYPE;
            }
            if (className.equals("float")) {
                return Float.TYPE;
            }
            if (className.equals("double")) {
                return Double.TYPE;
            }
            throw new NakedObjectRuntimeException((Throwable)e);
        }
        return cls;
    }

    private Object createObject(Class cls) {
        if (cls.isArray()) {
            return Array.newInstance(cls.getComponentType(), 0);
        }
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new NakedObjectRuntimeException("Cannot create an instance of an abstract class: " + cls);
        }
        Object object = this.createInstance(cls);
        this.initDomainObject(object);
        return object;
    }

    private Object createObject(NakedObjectSpecification specification) {
        Class cls = this.classFor(specification);
        Object object = this.createObject(cls);
        return object;
    }

    private NakedObject createObjectAdapter(Oid oid, Object object) {
        Assert.assertNotNull(oid);
        Assert.assertNotNull(object);
        Assert.assertFalse("POJO Map already contains object", object, this.pojoAdapterMap.containsPojo(object));
        Assert.assertFalse("Can't create an adapter for a NOF adapter", object instanceof Naked);
        PojoAdapter nakedObject = new PojoAdapter(object, oid);
        LOG.debug((Object)("created PojoAdapter@" + Integer.toHexString(nakedObject.hashCode()) + " for " + new ToString(object)));
        this.pojoAdapterMap.add(object, (Naked)nakedObject);
        LOG.debug((Object)("adding identity " + oid + " for " + nakedObject));
        this.identityAdapterMap.add(oid, nakedObject);
        return nakedObject;
    }

    public NakedObject createTransientInstance(NakedObjectSpecification specification) {
        Assert.assertTrue("must be an object", specification.getType() == 274);
        LOG.debug((Object)("creating transient instance of " + specification));
        Object object = this.createObject(specification);
        NakedObject adapter = this.createAdapterForTransient(object);
        return adapter;
    }

    public NakedCollection recreateCollection(NakedObjectSpecification collectionSpecification, NakedObjectSpecification elementSpecification) {
        Assert.assertFalse("must not be an object", collectionSpecification.getType() == 274);
        Assert.assertFalse("must not be a value", collectionSpecification.getType() == 273);
        LOG.debug((Object)("recreating collection " + collectionSpecification));
        Object object = this.createObject(collectionSpecification);
        NakedCollection adapter = this.createAdapterForCollection(object, elementSpecification);
        return adapter;
    }

    public NakedObject recreateTransientInstance(Oid oid, NakedObjectSpecification specification) {
        Assert.assertNotNull("must have an OID", oid);
        Assert.assertTrue("must be an object", specification, specification.getType() == 274);
        if (this.isIdentityKnown(oid)) {
            return this.getAdapterFor(oid);
        }
        LOG.debug((Object)("recreating transient instance of for " + specification));
        Object object = this.createObject(specification);
        NakedObject adapter = this.createObjectAdapter(oid, object);
        adapter.changeState(ResolveState.TRANSIENT);
        return adapter;
    }

    public NakedValue createValueInstance(NakedObjectSpecification specification) {
        Assert.assertTrue("must be a value", specification, specification.getType() == 273);
        return this.createAdapterForValue(specification);
    }

    public NakedObject getAdapterFor(Object object) {
        Assert.assertNotNull("can't get an adapter for null", this, object);
        NakedObject adapter = (NakedObject)this.pojoAdapterMap.getPojo(object);
        return adapter;
    }

    public NakedObject getAdapterFor(Oid oid) {
        Assert.assertNotNull("OID should not be null", this, oid);
        this.processChangedOid(oid);
        NakedObject adapter = this.identityAdapterMap.getAdapter(oid);
        return adapter;
    }

    public NakedCollection getAdapterForElseCreateAdapterForCollection(NakedObject parent, String fieldName, NakedObjectSpecification specification, Object collection) {
        Assert.assertNotNull("can't get an adapter for null", this, collection);
        InternalCollectionKey key = InternalCollectionKey.createKey(parent, fieldName);
        NakedCollection adapter = (NakedCollection)this.pojoAdapterMap.getPojo(key);
        if (adapter == null) {
            adapter = NakedObjectsContext.getReflector().createCollectionAdapter(collection, specification);
            this.pojoAdapterMap.add(key, (Naked)adapter);
            if (parent.getResolveState().isPersistent()) {
                LOG.debug((Object)("creating adapter for persistent collection: " + collection));
                adapter.changeState(ResolveState.GHOST);
            } else {
                LOG.debug((Object)("creating adapter for transient collection: " + collection));
                adapter.changeState(ResolveState.TRANSIENT);
            }
        } else {
            Assert.assertSame(collection, adapter.getObject());
        }
        Assert.assertNotNull("should have an adapter for ", collection, adapter);
        return adapter;
    }

    public NakedObject getAdapterForElseCreateAdapterForTransient(Object object) {
        NakedObject adapter = this.getAdapterFor(object);
        if (adapter == null) {
            LOG.debug((Object)("no existing adapter found; creating a transient adapter for " + new ToString(object)));
            adapter = this.createAdapterForTransient(object);
        }
        Assert.assertNotNull("should have an adapter for ", object, adapter);
        return adapter;
    }

    public void debugData(DebugString debug) {
        debug.appendln();
        debug.appendTitle("Services");
        for (int i = 0; i < this.services.length; ++i) {
            debug.append(i + 1, 5);
            debug.append(" ");
            debug.append(this.services[i].getClass().getName(), 30);
            debug.append("   ");
            debug.appendln(this.services[i].toString());
        }
        debug.appendln();
        debug.appendTitle("POJO-Adapter Mappings");
        this.pojoAdapterMap.debugData(debug);
        debug.appendln();
        debug.appendTitle("Identity-Adapter Mappings");
        Enumeration e = this.identityAdapterMap.oids();
        int count = 0;
        while (e.hasMoreElements()) {
            Oid oid = (Oid)e.nextElement();
            NakedObject object = this.identityAdapterMap.getAdapter(oid);
            debug.append(count++ + 1, 5);
            debug.append(" ");
            debug.append(oid.toString(), 12);
            debug.append("    ");
            debug.appendln(object.toString());
        }
        debug.appendln();
    }

    public String debugTitle() {
        return "Object Loader";
    }

    public Enumeration getIdentifiedObjects() {
        return this.pojoAdapterMap.elements();
    }

    public void init() {
        LOG.debug((Object)("initialising " + this));
        if (this.identityAdapterMap == null) {
            this.identityAdapterMap = new IdentityAdapterHashMap();
        }
        if (this.pojoAdapterMap == null) {
            this.pojoAdapterMap = new PojoAdapterHashMap();
        }
        this.addAdapterClass(String.class, StringAdapter.class);
        this.addAdapterClass(Date.class, DateAdapter.class);
        this.addAdapterClass(Time.class, TimeAdapter.class);
        this.addAdapterClass(java.util.Date.class, DateTimeAdapter.class);
        this.addAdapterClass(Image.class, ImageAdapter.class);
        this.addAdapterClass(Boolean.class, BooleanAdapter.class);
        this.addAdapterClass(Character.class, CharAdapter.class);
        this.addAdapterClass(Byte.class, ByteAdapter.class);
        this.addAdapterClass(Short.class, ShortAdapter.class);
        this.addAdapterClass(Integer.class, IntAdapter.class);
        this.addAdapterClass(Long.class, LongAdapter.class);
        this.addAdapterClass(Float.class, FloatAdapter.class);
        this.addAdapterClass(Double.class, DoubleAdapter.class);
        this.addAdapterClass(Boolean.TYPE, BooleanAdapter.class);
        this.addAdapterClass(Character.TYPE, CharAdapter.class);
        this.addAdapterClass(Byte.TYPE, ByteAdapter.class);
        this.addAdapterClass(Short.TYPE, ShortAdapter.class);
        this.addAdapterClass(Integer.TYPE, IntAdapter.class);
        this.addAdapterClass(Long.TYPE, LongAdapter.class);
        this.addAdapterClass(Float.TYPE, FloatAdapter.class);
        this.addAdapterClass(Double.TYPE, DoubleAdapter.class);
        this.addAdapterClass(BigDecimal.class, BigDecimalAdapter.class);
        this.addAdapterClass(BigInteger.class, BigIntegerAdapter.class);
        for (int i = 0; i < this.services.length; ++i) {
            Object service = this.services[i];
            this.initDomainObject(service);
        }
    }

    public boolean isIdentityKnown(Oid oid) {
        Assert.assertNotNull(oid);
        this.processChangedOid(oid);
        return this.identityAdapterMap.isIdentityKnown(oid);
    }

    public void start(NakedReference object, ResolveState state) {
        LOG.debug((Object)("start " + object + " as " + state.name()));
        object.changeState(state);
    }

    public void end(NakedReference object) {
        ResolveState endState = object.getResolveState().getEndState();
        LOG.debug((Object)("end " + object + " as " + endState.name()));
        object.changeState(endState);
    }

    public void madePersistent(NakedReference adapter) {
        Oid oid = adapter.getOid();
        this.identityAdapterMap.remove(oid);
        NakedObjectsContext.getObjectPersistor().convertTransientToPersistentOid(oid);
        adapter.changeState(ResolveState.RESOLVED);
        Assert.assertTrue("Adapter's pojo should exist in pojo map and return the adapter", adapter.getObject(), this.pojoAdapterMap.getPojo(adapter.getObject()) == adapter);
        Assert.assertNull("Changed OID should not already map to a known adapter " + oid, this.identityAdapterMap.getAdapter(oid));
        this.identityAdapterMap.add(oid, adapter);
        LOG.debug((Object)("made persistent " + adapter + "; was " + oid.getPrevious()));
    }

    public NakedObject recreateAdapterForPersistent(Oid oid, NakedObjectSpecification specification) {
        Assert.assertNotNull("must have an OID", oid);
        Assert.assertTrue("must be an object", specification.getType() == 274);
        if (this.isIdentityKnown(oid)) {
            return this.getAdapterFor(oid);
        }
        LOG.debug((Object)("recreating object " + specification.getFullName() + "/" + oid));
        Object object = this.createObject(specification);
        NakedObject adapter = this.createObjectAdapter(oid, object);
        adapter.changeState(ResolveState.GHOST);
        return adapter;
    }

    public NakedObject recreateAdapter(Oid oid, Object object) {
        Assert.assertNotNull("must have an OID", oid);
        if (this.isIdentityKnown(oid)) {
            return this.getAdapterFor(oid);
        }
        NakedObject adapter = this.createObjectAdapter(oid, object);
        adapter.changeState(oid.isTransient() ? ResolveState.TRANSIENT : ResolveState.GHOST);
        return adapter;
    }

    public void setIdentityAdapterMap(IdentityAdapterMap identityAdapterMap) {
        this.identityAdapterMap = identityAdapterMap;
    }

    public void set_IdentityAdapterMap(IdentityAdapterMap identityAdapterMap) {
        this.setIdentityAdapterMap(identityAdapterMap);
    }

    public void setPojoAdapterMap(PojoAdapterMap pojoAdapterMap) {
        this.pojoAdapterMap = pojoAdapterMap;
    }

    public void set_PojoAdapterMap(PojoAdapterMap pojoAdapterMap) {
        this.setPojoAdapterMap(pojoAdapterMap);
    }

    public Object[] getServices() {
        return this.services;
    }

    public void setServices(Object[] services) {
        this.services = services;
    }

    public void reset() {
        this.identityAdapterMap.reset();
        this.pojoAdapterMap.reset();
        InternalCollectionKey.reset();
    }

    public void shutdown() {
        LOG.info((Object)("shutting down " + this));
        this.identityAdapterMap.shutdown();
        this.identityAdapterMap = null;
        this.pojoAdapterMap.shutdown();
        InternalCollectionKey.reset();
    }

    public void unloaded(NakedObject object) {
        LOG.debug((Object)("unload ignored: " + object));
        LOG.debug((Object)("removed loaded object " + object));
        Oid oid = object.getOid();
        if (oid != null) {
            this.identityAdapterMap.remove(oid);
        }
        this.pojoAdapterMap.remove((Naked)object);
    }

    private void processChangedOid(Oid oid) {
        Oid previous;
        NakedObject object;
        if (oid.hasPrevious() && (object = this.identityAdapterMap.getAdapter(previous = oid.getPrevious())) != null) {
            LOG.debug((Object)("updating oid " + previous + " to " + oid));
            this.identityAdapterMap.remove(previous);
            Oid oidFromObject = object.getOid();
            oidFromObject.copyFrom(oid);
            this.identityAdapterMap.add(oidFromObject, (NakedReference)object);
        }
    }

    public Naked[] getAdapters(SpecObjectPair[] pairs) {
        Naked[] nakeds = new Naked[pairs.length];
        for (int i = 0; i < pairs.length; ++i) {
            nakeds[i] = this.getAdapter(pairs[i]);
        }
        return nakeds;
    }

    public Naked getAdapter(SpecObjectPair pair) {
        NakedObjectSpecification spec = pair.getSpecification();
        Object object = pair.getObject();
        int specType = spec.getType();
        if (object instanceof Naked) {
            return (Naked)object;
        }
        if (specType == 273) {
            if (object == null) {
                return this.createAdapterForValue(spec);
            }
            return this.createAdapterForValue(object);
        }
        if (specType == 274) {
            if (object == null) {
                return null;
            }
            return this.getAdapterForElseCreateAdapterForTransient(object);
        }
        if (specType == 275) {
            if (object == null) {
                return null;
            }
            NakedCollectionSpecification collSpec = (NakedCollectionSpecification)spec;
            NakedObjectSpecification elementSpec = collSpec.getElementType();
            return this.createAdapterForCollection(object, elementSpec);
        }
        throw new UnknownTypeException("Unable to decode NakedObjectSpecification; pair = " + pair);
    }
}

