/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.map;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.nof.core.adapter.map.PojoAdapterMap;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ToString;

public class PojoAdapterHashMap
implements PojoAdapterMap {
    private static final Logger LOG = Logger.getLogger(PojoAdapterHashMap.class);
    protected final Hashtable pojos;

    public PojoAdapterHashMap() {
        this(10);
    }

    public PojoAdapterHashMap(int capacity) {
        this.pojos = new Hashtable(capacity);
    }

    public void add(Object pojo, Naked adapter) {
        LOG.debug((Object)("add " + new ToString(pojo) + " as " + adapter));
        this.pojos.put(pojo, adapter);
    }

    public boolean containsPojo(Object pojo) {
        return this.pojos.containsKey(pojo);
    }

    public Enumeration elements() {
        return this.pojos.elements();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.info((Object)"finalizing hash of pojos");
    }

    public void debugData(DebugString debug) {
        Enumeration e = this.pojos.keys();
        int count = 0;
        while (e.hasMoreElements()) {
            Object pojo = e.nextElement();
            NakedReference object = (NakedReference)this.pojos.get(pojo);
            debug.append(count++ + 1, 5);
            debug.append(" '");
            debug.append(pojo.toString(), 25);
            debug.append("'    ");
            debug.appendln(object.toString());
        }
    }

    public String debugTitle() {
        return "POJO Adapter Hashtable";
    }

    public Naked getPojo(Object pojo) {
        return (Naked)this.pojos.get(pojo);
    }

    public void reset() {
        LOG.debug((Object)"reset");
        this.pojos.clear();
    }

    public void shutdown() {
        LOG.debug((Object)"shutdown");
        this.pojos.clear();
    }

    public void remove(Naked object) {
        LOG.debug((Object)("remove " + object));
        this.pojos.remove(object.getObject());
    }
}

