/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import org.nakedobjects.noa.adapter.value.DateValue;
import org.nakedobjects.nof.core.adapter.value.AbstractTemporalValueAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public abstract class AbstractDateAdapter
extends AbstractTemporalValueAdapter
implements DateValue {
    private static Hashtable formats = new Hashtable();

    public AbstractDateAdapter() {
        super("date");
        String formatRequired = NakedObjectsContext.getConfiguration().getString("nakedobjects.value.format.date");
        if (formatRequired == null) {
            this.format = (DateFormat)this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    protected void clearFields(Calendar cal) {
        cal.set(10, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(9, 0);
        cal.set(14, 0);
    }

    protected String defaultFormat() {
        return "medium";
    }

    public int defaultTypicalLength() {
        return 12;
    }

    public String getIconName() {
        return "date";
    }

    protected boolean ignoreTimeZone() {
        return true;
    }

    protected Hashtable formats() {
        return formats;
    }

    static {
        formats.put("iso", AbstractDateAdapter.createDateFormat("yyyy-MM-dd"));
        formats.put("iso_encoding", AbstractDateAdapter.createDateFormat("yyyyMMdd"));
        formats.put("long", DateFormat.getDateInstance(1));
        formats.put("medium", DateFormat.getDateInstance(2));
        formats.put("short", DateFormat.getDateInstance(3));
    }
}

