/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.text.DateFormat;
import java.util.Hashtable;
import org.nakedobjects.nof.core.adapter.value.AbstractTemporalValueAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public abstract class AbstractDateTimeAdapter
extends AbstractTemporalValueAdapter {
    private static Hashtable formats = new Hashtable();

    public AbstractDateTimeAdapter() {
        super("datetime");
        String formatRequired = NakedObjectsContext.getConfiguration().getString("nakedobjects.value.format.datetime");
        if (formatRequired == null) {
            this.format = (DateFormat)this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    protected String defaultFormat() {
        return "medium";
    }

    public int defaultTypicalLength() {
        return 18;
    }

    protected Hashtable formats() {
        return formats;
    }

    public String getIconName() {
        return "time";
    }

    static {
        formats.put("iso", AbstractDateTimeAdapter.createDateFormat("yyyy-MM-dd HH:mm"));
        formats.put("iso_short", AbstractDateTimeAdapter.createDateFormat("yyyyMMdd'T'HHmm"));
        formats.put("iso_sec", AbstractDateTimeAdapter.createDateFormat("yyyy-MM-dd HH:mm:ss"));
        formats.put("iso_sec_short", AbstractDateTimeAdapter.createDateFormat("yyyyMMdd'T'HHmmss"));
        formats.put("iso_milli", AbstractDateTimeAdapter.createDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        formats.put("iso_milli_short", AbstractDateTimeAdapter.createDateFormat("yyyyMMdd'T'HHmmssSSS"));
        formats.put("iso_encoding", AbstractDateTimeAdapter.createDateFormat("yyyyMMdd'T'HHmmssSSS"));
        formats.put("long", DateFormat.getDateTimeInstance(1, 1));
        formats.put("medium", DateFormat.getDateTimeInstance(2, 3));
        formats.put("short", DateFormat.getDateTimeInstance(3, 3));
    }
}

