/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.value.ImageValue;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;
import org.nakedobjects.nof.core.util.UnexpectedCallException;

public abstract class AbstractImageAdapter
extends AbstractValueAdapter
implements ImageValue {
    private static final char[] BASE_64_CHARS;
    protected static final byte[] REVERSE_BASE_64_CHARS;
    private static final Logger LOG;

    public byte[] getAsByteArray() {
        int[] flatIntArray = this.flatten();
        byte[] byteArray = new byte[flatIntArray.length * 4];
        for (int i = 0; i < flatIntArray.length; ++i) {
            int value = flatIntArray[i];
            byteArray[i * 4] = (byte)(value >> 24 & 0xFF);
            byteArray[i * 4 + 1] = (byte)(value >> 16 & 0xFF);
            byteArray[i * 4 + 2] = (byte)(value >> 8 & 0xFF);
            byteArray[i * 4 + 3] = (byte)(value & 0xFF);
        }
        return byteArray;
    }

    private static int byteArrayToInt(byte[] byteArray, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (byteArray[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    public void restoreFromByteArray(byte[] byteArray) {
        int[] flatIntArray = new int[byteArray.length / 4];
        for (int i = 0; i < flatIntArray.length; ++i) {
            flatIntArray[i] = AbstractImageAdapter.byteArrayToInt(byteArray, i * 4);
        }
        this.setPixels(AbstractImageAdapter.inflate(flatIntArray));
    }

    private int[] flatten() {
        int[][] image = this.getPixels();
        int[] flatArray = new int[this.getHeight() * this.getWidth() + 2];
        int flatIndex = 0;
        flatArray[flatIndex++] = this.getHeight();
        flatArray[flatIndex++] = this.getWidth();
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = 0; j < this.getWidth(); ++j) {
                flatArray[flatIndex++] = image[i][j];
            }
        }
        return flatArray;
    }

    private static int[][] inflate(int[] flatIntArray) {
        int flatIndex = 0;
        int height = flatIntArray[flatIndex++];
        int width = flatIntArray[flatIndex++];
        int[][] newImage = new int[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                newImage[i][j] = flatIntArray[flatIndex++];
            }
        }
        return newImage;
    }

    protected String doEncode() {
        int[][] image = this.getPixels();
        int lines = image.length;
        int width = image[0].length;
        StringBuffer encodeData = new StringBuffer(lines * width * 4);
        this.encodePixel(lines, encodeData);
        this.encodePixel(width, encodeData);
        for (int line = 0; line < lines; ++line) {
            for (int pixel = 0; pixel < width; ++pixel) {
                this.encodePixel(image[line][pixel], encodeData);
            }
        }
        return encodeData.toString();
    }

    protected Image createImage(int[][] pixels) {
        int lines = pixels.length;
        int width = pixels[0].length;
        int[] pix = new int[lines * width];
        int offset = 0;
        for (int line = 0; line < lines; ++line) {
            System.arraycopy(pixels[line], 0, pix, offset, width);
            offset += width;
        }
        MemoryImageSource source = new MemoryImageSource(width, lines, pix, 0, width);
        return Toolkit.getDefaultToolkit().createImage(source);
    }

    private int decodePixel(String data, int item) {
        int offset = item * 4;
        int pixel = 0;
        for (int i = 0; i < 4; ++i) {
            char c = data.charAt(offset + i);
            byte b = REVERSE_BASE_64_CHARS[c];
            pixel = (pixel << 6) + b;
        }
        return pixel;
    }

    private void encodePixel(int pixel, StringBuffer encodeData) {
        for (int i = 3; i >= 0; --i) {
            int bitsToShift = i * 6;
            int c = pixel >> bitsToShift;
            char cc = BASE_64_CHARS[c & 0x3F];
            encodeData.append(cc);
        }
    }

    public String getIconName() {
        return null;
    }

    protected abstract int[][] getPixels();

    protected int[][] grabPixels(Image image) {
        int width = image.getWidth(null);
        int lines = image.getHeight(null);
        int[] pixels = new int[width * lines];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, lines, pixels, 0, width);
        grabber.setColorModel(ColorModel.getRGBdefault());
        try {
            if (grabber.grabPixels() && (grabber.status() & 0x20) != 0) {
                int[][] array = new int[lines][width];
                int srcPos = 0;
                for (int line = 0; line < lines; ++line) {
                    array[line] = new int[width];
                    System.arraycopy(pixels, srcPos, array[line], 0, width);
                    srcPos += width;
                }
                return array;
            }
            return new int[lines][width];
        }
        catch (InterruptedException e) {
            throw new NakedObjectRuntimeException((Throwable)e);
        }
    }

    public void parseTextEntry(String text) {
        throw new UnexpectedCallException();
    }

    protected void doParse(String entry) {
    }

    protected void doRestore(String data) {
        int lines = this.decodePixel(data, 0);
        int width = this.decodePixel(data, 1);
        int[][] image = new int[lines][width];
        int offset = 2;
        for (int line = 0; line < lines; ++line) {
            for (int pixel = 0; pixel < width; ++pixel) {
                image[line][pixel] = this.decodePixel(data, offset++);
            }
        }
        this.setPixels(image);
    }

    protected abstract void setPixels(int[][] var1);

    public void setMask(String mask) {
    }

    public String titleString() {
        return "image";
    }

    static {
        int i;
        BASE_64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        REVERSE_BASE_64_CHARS = new byte[256];
        LOG = Logger.getLogger(AbstractImageAdapter.class);
        for (i = 0; i < REVERSE_BASE_64_CHARS.length; ++i) {
            AbstractImageAdapter.REVERSE_BASE_64_CHARS[i] = -1;
        }
        for (i = 0; i < BASE_64_CHARS.length; i = (int)((byte)(i + 1))) {
            AbstractImageAdapter.REVERSE_BASE_64_CHARS[AbstractImageAdapter.BASE_64_CHARS[i]] = i;
        }
    }
}

