/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;
import org.nakedobjects.nof.core.adapter.value.EncodingException;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public abstract class AbstractTemporalValueAdapter
extends AbstractValueAdapter {
    protected static final String ISO_ENCODING_FORMAT = "iso_encoding";
    private static final TimeZone UTC_TIME_ZONE;
    private static DateFormat encodingFormat;
    protected DateFormat format;

    protected static DateFormat createDateFormat(String mask) {
        return new SimpleDateFormat(mask);
    }

    public AbstractTemporalValueAdapter(String propertyName) {
        Hashtable formats = this.formats();
        Enumeration elements = formats.elements();
        while (elements.hasMoreElements()) {
            DateFormat format = (DateFormat)elements.nextElement();
            format.setLenient(false);
            if (!this.ignoreTimeZone()) continue;
            format.setTimeZone(UTC_TIME_ZONE);
        }
        String defaultFormat = NakedObjectsContext.getConfiguration().getString("nakedobjects.value.format." + propertyName, this.defaultFormat());
        String required = defaultFormat.toLowerCase().trim();
        this.format = (DateFormat)formats.get(required);
        if (this.format == null) {
            this.setMask(defaultFormat);
        }
        encodingFormat = (DateFormat)formats.get(ISO_ENCODING_FORMAT);
    }

    protected abstract void add(int var1, int var2, int var3, int var4, int var5);

    public boolean canClear() {
        return true;
    }

    protected void clearFields(Calendar cal) {
    }

    protected abstract Date dateValue();

    protected abstract String defaultFormat();

    public int defaultTypicalLength() {
        return 12;
    }

    protected abstract Hashtable formats();

    public String getIconName() {
        return "date";
    }

    public Oid getOid() {
        return null;
    }

    protected boolean ignoreTimeZone() {
        return false;
    }

    protected abstract void now();

    protected abstract void setDate(Date var1);

    public void setMask(String mask) {
        this.format = new SimpleDateFormat(mask);
        this.format.setLenient(false);
        this.format.setTimeZone(UTC_TIME_ZONE);
    }

    public String titleString() {
        Date date = this.dateValue();
        return date == null ? "" : this.format.format(date);
    }

    private void parseDate(String dateString) {
        try {
            this.setDate(this.format.parse(dateString));
        }
        catch (ParseException e) {
            Hashtable formats = this.formats();
            Enumeration elements = formats.elements();
            this.setDate(this.parseDate(dateString, elements));
        }
    }

    private Date parseDate(String dateString, Enumeration elements) {
        DateFormat format = (DateFormat)elements.nextElement();
        try {
            return format.parse(dateString);
        }
        catch (ParseException e) {
            if (elements.hasMoreElements()) {
                return this.parseDate(dateString, elements);
            }
            throw new TextEntryParseException("Not recognised as a date: " + dateString);
        }
    }

    protected void doParse(String entry) {
        String dateString = entry.trim();
        String str = dateString.toLowerCase();
        if (str.equals("today") || str.equals("now")) {
            this.now();
        } else if (dateString.startsWith("+")) {
            this.relativeDate(dateString, true);
        } else if (dateString.startsWith("-")) {
            this.relativeDate(dateString, false);
        } else {
            this.parseDate(dateString);
        }
    }

    private void relativeDate(String str, boolean add) {
        if (this.isEmpty()) {
            this.now();
        }
        StringTokenizer st = new StringTokenizer(str.substring(1), " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.relativeDate2(token, add);
        }
    }

    private void relativeDate2(String str, boolean add) {
        int hours = 0;
        int minutes = 0;
        int days = 0;
        int months = 0;
        int years = 0;
        if (str.endsWith("H")) {
            str = str.substring(0, str.length() - 1);
            hours = Integer.valueOf(str);
        } else if (str.endsWith("M")) {
            str = str.substring(0, str.length() - 1);
            minutes = Integer.valueOf(str);
        } else if (str.endsWith("w")) {
            str = str.substring(0, str.length() - 1);
            days = 7 * Integer.valueOf(str);
        } else if (str.endsWith("y")) {
            str = str.substring(0, str.length() - 1);
            years = Integer.valueOf(str);
        } else if (str.endsWith("m")) {
            str = str.substring(0, str.length() - 1);
            months = Integer.valueOf(str);
        } else if (str.endsWith("d")) {
            str = str.substring(0, str.length() - 1);
            days = Integer.valueOf(str);
        } else {
            days = Integer.valueOf(str);
        }
        if (add) {
            this.add(years, months, days, hours, minutes);
        } else {
            this.add(-years, -months, -days, -hours, -minutes);
        }
    }

    protected String doEncode() {
        Date date = this.dateValue();
        return encodingFormat.format(date);
    }

    protected void doRestore(String data) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(encodingFormat.parse(data));
            this.clearFields(cal);
            this.setDate(cal.getTime());
        }
        catch (ParseException e) {
            throw new EncodingException(e);
        }
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("Etc/UTC");
        if (timeZone == null) {
            timeZone = TimeZone.getTimeZone("UTC");
        }
        UTC_TIME_ZONE = timeZone;
    }
}

