/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import org.nakedobjects.noa.adapter.value.TimeValue;
import org.nakedobjects.nof.core.adapter.value.AbstractTemporalValueAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public abstract class AbstractTimeAdapter
extends AbstractTemporalValueAdapter
implements TimeValue {
    protected static void initFormats(Hashtable formats) {
        formats.put("iso", AbstractTimeAdapter.createDateFormat("HH:mm"));
        formats.put("iso_sec", AbstractTimeAdapter.createDateFormat("HH:mm:ss"));
        formats.put("iso_milli", AbstractTimeAdapter.createDateFormat("HH:mm:ss.SSS"));
        formats.put("iso_encoding", AbstractTimeAdapter.createDateFormat("HHmmssSSS"));
        formats.put("long", DateFormat.getTimeInstance(1));
        formats.put("medium", DateFormat.getTimeInstance(2));
        formats.put("short", DateFormat.getTimeInstance(3));
    }

    protected void clearFields(Calendar cal) {
        cal.set(1, 0);
        cal.set(2, 0);
        cal.set(5, 0);
    }

    public AbstractTimeAdapter() {
        super("time");
        String formatRequired = NakedObjectsContext.getConfiguration().getString("nakedobjects.value.format.time");
        if (formatRequired == null) {
            this.format = (DateFormat)this.formats().get(this.defaultFormat());
        } else {
            this.setMask(formatRequired);
        }
    }

    protected String defaultFormat() {
        return "short";
    }

    public int defaultTypicalLength() {
        return 6;
    }

    public String getIconName() {
        return "time";
    }
}

