/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.FieldRegEx;
import org.nakedobjects.noa.adapter.InvalidEntryException;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.Assert;

public abstract class AbstractValueAdapter
implements NakedValue {
    private NakedObjectSpecification specification;

    public boolean canClear() {
        return true;
    }

    public int defaultTypicalLength() {
        return 0;
    }

    public int getMaximumLength() {
        return 0;
    }

    public int getMinumumLength() {
        return 0;
    }

    public NakedObjectSpecification getSpecification() {
        if (this.specification == null) {
            this.specification = NakedObjectsContext.getReflector().loadSpecification(this.getValueClass());
        }
        return this.specification;
    }

    public abstract Class getValueClass();

    public void parseTextEntry(String entry) {
        if (entry == null) {
            throw new IllegalArgumentException("An entry must be provided");
        }
        if (entry.trim().equals("") && this.canClear()) {
            this.clear();
        } else {
            if (entry.trim().equals("") && this.mustHaveEntry()) {
                throw new InvalidEntryException("An entry is required");
            }
            this.doParse(entry);
        }
    }

    protected boolean mustHaveEntry() {
        return false;
    }

    protected abstract void doParse(String var1);

    public String asEncodedString() {
        return this.isEmpty() ? "NULL" : this.doEncode();
    }

    protected abstract String doEncode();

    public void restoreFromEncodedString(String data) {
        Assert.assertNotNull(data);
        if ("NULL".equals(data)) {
            this.clear();
        } else {
            this.doRestore(data);
        }
    }

    protected abstract void doRestore(String var1);

    public void setRegEx(FieldRegEx regaEx) {
    }

    public abstract String toString();
}

