/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public class BigDecimalAdapter
extends AbstractValueAdapter {
    private static final NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format;
    private BigDecimal value;

    public BigDecimalAdapter() {
        String formatRequired = NakedObjectsContext.getConfiguration().getString("nakedobjects.value.format.decimal");
        if (formatRequired == null) {
            this.format = DEFAULT_FORMAT;
        } else {
            this.setMask(formatRequired);
        }
    }

    public BigDecimalAdapter(BigDecimal value) {
        this();
        this.value = value;
    }

    public String titleString() {
        return this.isEmpty() ? "" : this.format.format(this.value);
    }

    public String getIconName() {
        return "bigdecimal";
    }

    public Class getValueClass() {
        return BigDecimal.class;
    }

    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean canClear() {
        return true;
    }

    public void clear() {
        this.value = null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    protected void doParse(String entry) {
        try {
            this.value = new BigDecimal(entry);
        }
        catch (NumberFormatException e) {
            throw new TextEntryParseException("Not an decimal " + entry, (Throwable)e);
        }
    }

    protected String doEncode() {
        return this.toPlainString();
    }

    protected void doRestore(String data) {
        this.value = new BigDecimal(data);
    }

    public void setMask(String mask) {
        this.format = new DecimalFormat(mask);
    }

    public int defaultTypicalLength() {
        return 19;
    }

    public String toString() {
        return "BigDecimalAdapter: " + (this.value != null ? this.toPlainString() : "NULL");
    }

    private String toPlainString() {
        try {
            Class<?> cls = this.value.getClass();
            try {
                return (String)cls.getMethod("toPlainString", null).invoke((Object)this.value, (Object[])null);
            }
            catch (NoSuchMethodException nsm) {
                return (String)cls.getMethod("toString", null).invoke((Object)this.value, (Object[])null);
            }
        }
        catch (Exception e) {
            throw new NakedObjectRuntimeException((Throwable)e);
        }
    }
}

