/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public class BigIntegerAdapter
extends AbstractValueAdapter {
    private static final NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format;
    private BigInteger value;

    public BigIntegerAdapter() {
        String formatRequired = NakedObjectsContext.getConfiguration().getString("nakedobjects.value.format.int");
        if (formatRequired == null) {
            this.format = DEFAULT_FORMAT;
        } else {
            this.setMask(formatRequired);
        }
    }

    public BigIntegerAdapter(BigInteger value) {
        this();
        this.value = value;
    }

    public String titleString() {
        return this.isEmpty() ? "" : this.format.format(this.value);
    }

    public String getIconName() {
        return "biginteger";
    }

    public Class getValueClass() {
        return BigInteger.class;
    }

    public BigInteger bigDecimalValue() {
        return this.value;
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean canClear() {
        return true;
    }

    public void clear() {
        this.value = null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    protected void doParse(String entry) {
        try {
            this.value = new BigInteger(entry);
        }
        catch (NumberFormatException e) {
            throw new TextEntryParseException("Not an decimal " + entry, (Throwable)e);
        }
    }

    protected String doEncode() {
        return this.value.toString();
    }

    protected void doRestore(String data) {
        this.value = new BigInteger(data);
    }

    public void setMask(String mask) {
        this.format = new DecimalFormat(mask);
    }

    public int defaultTypicalLength() {
        return 19;
    }

    public String toString() {
        return "BigIntegerAdapter: " + (this.value != null ? this.value.toString() : "NULL");
    }
}

