/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.adapter.value.BooleanValue;
import org.nakedobjects.noa.persist.ObjectPersistenceException;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;

public class BooleanAdapter
extends AbstractValueAdapter
implements BooleanValue {
    private Boolean value;

    public BooleanAdapter() {
        this.value = Boolean.FALSE;
    }

    public BooleanAdapter(Boolean value) {
        this.value = value;
    }

    public String titleString() {
        return this.isEmpty() ? "" : (this.isSet() ? "True" : "False");
    }

    public String getIconName() {
        return "boolean";
    }

    public Class getValueClass() {
        return Boolean.TYPE;
    }

    public Boolean boolValue() {
        return this.value;
    }

    public Boolean booleanValue() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean isSet() {
        return this.isEmpty() ? false : this.value;
    }

    public boolean canClear() {
        return true;
    }

    public void clear() {
        this.value = null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void reset() {
        this.value = Boolean.FALSE;
    }

    public void set() {
        this.value = Boolean.TRUE;
    }

    public void toggle() {
        this.value = this.isEmpty() ? Boolean.TRUE : new Boolean(this.value == false);
    }

    protected void doParse(String entry) {
        if ("true".startsWith(entry.toLowerCase())) {
            this.set();
        } else if ("false".startsWith(entry.toLowerCase())) {
            this.reset();
        } else {
            throw new TextEntryParseException("Not a logical value " + entry);
        }
    }

    protected String doEncode() {
        return this.isSet() ? "T" : "F";
    }

    protected void doRestore(String data) {
        if (data.length() != 1) {
            throw new ObjectPersistenceException("Invalid data for logical, expected 1 byte, got " + data.length());
        }
        switch (data.charAt(0)) {
            case 'T': {
                this.set();
                break;
            }
            case 'F': {
                this.reset();
                break;
            }
            default: {
                throw new ObjectPersistenceException("Invalid data for logical, expected 'T', 'F' or 'N, but got " + data.charAt(0));
            }
        }
    }

    public void setMask(String mask) {
    }

    public int defaultTypicalLength() {
        return 5;
    }

    public String toString() {
        return "BooleanAdapter: " + this.value;
    }
}

