/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.adapter.value.ByteValue;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public class ByteAdapter
extends AbstractValueAdapter
implements ByteValue {
    private static final NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format = DEFAULT_FORMAT;
    private Byte value;

    public ByteAdapter() {
        String formatRequired = NakedObjectsContext.getConfiguration().getString("nakedobjects.value.format.byte");
        if (formatRequired == null) {
            this.format = DEFAULT_FORMAT;
        } else {
            this.setMask(formatRequired);
        }
    }

    public ByteAdapter(Byte value) {
        this();
        this.value = value;
    }

    public String titleString() {
        return this.value == null ? "" : this.format.format(this.value);
    }

    public String getIconName() {
        return "byte";
    }

    public Class getValueClass() {
        return Byte.class;
    }

    public Byte byteValue() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean canClear() {
        return true;
    }

    public void clear() {
        this.value = null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void setValue(Byte value) {
        this.value = value;
    }

    protected void doParse(String entry) {
        try {
            this.value = new Byte(this.format.parse(entry).byteValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not a number " + entry, (Throwable)e);
        }
    }

    public String doEncode() {
        return this.value.toString();
    }

    protected void doRestore(String data) {
        this.value = new Byte(data);
    }

    public void setMask(String mask) {
        this.format = new DecimalFormat(mask);
    }

    public int defaultTypicalLength() {
        return 4;
    }

    public String toString() {
        return "ByteAdapter: " + this.value;
    }
}

