/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.InvalidEntryException;
import org.nakedobjects.noa.adapter.value.CharValue;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;

public class CharAdapter
extends AbstractValueAdapter
implements CharValue {
    private Character value;

    public CharAdapter() {
    }

    public CharAdapter(char value) {
        this.value = new Character(value);
    }

    public CharAdapter(Character value) {
        this.value = value;
    }

    public String getIconName() {
        return "char";
    }

    public Class getValueClass() {
        return Character.class;
    }

    public Character charValue() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean canClear() {
        return true;
    }

    public void clear() {
        this.value = null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void setValue(Character value) {
        this.value = value;
    }

    public void doParse(String entry) {
        if (entry.length() > 1) {
            throw new InvalidEntryException("Only a single character is required");
        }
        this.value = new Character(entry.charAt(0));
    }

    protected String doEncode() {
        return this.value.toString();
    }

    protected void doRestore(String data) {
        this.value = new Character(data.charAt(0));
    }

    public void setMask(String mask) {
    }

    public int defaultTypicalLength() {
        return 1;
    }

    public String titleString() {
        return this.value == null ? "" : this.value.toString();
    }

    public String toString() {
        return "CharAdapter: " + this.value;
    }
}

