/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.util.Calendar;
import java.util.Date;
import org.nakedobjects.applib.clock.Clock;
import org.nakedobjects.nof.core.adapter.value.AbstractDateTimeAdapter;

public class DateTimeAdapter
extends AbstractDateTimeAdapter {
    private Date date;

    public DateTimeAdapter() {
    }

    public DateTimeAdapter(Date date) {
        this();
        this.date = date;
    }

    public void clear() {
        this.date = null;
    }

    public boolean isEmpty() {
        return this.date == null;
    }

    public Date dateValue() {
        return this.date == null ? null : new Date(this.date.getTime());
    }

    public Object getObject() {
        return this.date;
    }

    public Class getValueClass() {
        return Date.class;
    }

    public void setValue(Date date) {
        this.date = new Date(date.getTime());
    }

    public String toString() {
        return "DateTimeAdapter: " + this.date;
    }

    protected void add(int years, int months, int days, int hours, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(1, years);
        cal.add(2, months);
        cal.add(5, days);
        cal.add(10, hours);
        cal.add(12, minutes);
        this.setDate(cal.getTime());
    }

    protected void now() {
        this.date = new Date(Clock.getTime());
    }

    protected void setDate(Date date) {
        this.date = date;
    }
}

