/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.adapter.value.DoubleFloatingPointValue;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public class DoubleAdapter
extends AbstractValueAdapter
implements DoubleFloatingPointValue {
    private static final NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format = DEFAULT_FORMAT;
    private Double value;

    public DoubleAdapter() {
        String formatRequired = NakedObjectsContext.getConfiguration().getString("nakedobjects.value.format.double");
        if (formatRequired == null) {
            this.format = DEFAULT_FORMAT;
        } else {
            this.setMask(formatRequired);
        }
    }

    public DoubleAdapter(Double value) {
        this();
        this.value = value;
    }

    public String titleString() {
        return this.value == null ? "" : this.format.format(this.value);
    }

    public String getIconName() {
        return "double";
    }

    public Class getValueClass() {
        return Double.class;
    }

    public Double doubleValue() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean canClear() {
        return true;
    }

    public void clear() {
        this.value = null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    protected void doParse(String entry) {
        try {
            this.value = new Double(this.format.parse(entry).doubleValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not floating point number " + entry, (Throwable)e);
        }
    }

    protected String doEncode() {
        return this.value.toString();
    }

    protected void doRestore(String data) {
        this.value = new Double(data);
    }

    public void setMask(String mask) {
        this.format = new DecimalFormat(mask);
    }

    public int defaultTypicalLength() {
        return 22;
    }

    public String toString() {
        return "DoubleAdapter: " + this.value;
    }
}

