/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.adapter.value.FloatingPointValue;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public class FloatAdapter
extends AbstractValueAdapter
implements FloatingPointValue {
    private static final NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format = DEFAULT_FORMAT;
    private Float value;

    public FloatAdapter() {
        String formatRequired = NakedObjectsContext.getConfiguration().getString("nakedobjects.value.format.float");
        if (formatRequired == null) {
            this.format = DEFAULT_FORMAT;
        } else {
            this.setMask(formatRequired);
        }
    }

    public FloatAdapter(Float value) {
        this();
        this.value = value;
    }

    public String titleString() {
        return this.value == null ? "" : this.format.format(this.value);
    }

    public String getIconName() {
        return "float";
    }

    public Class getValueClass() {
        return Float.class;
    }

    public Float floatValue() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean canClear() {
        return true;
    }

    public void clear() {
        this.value = null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    protected void doParse(String entry) {
        try {
            this.value = new Float(this.format.parse(entry).floatValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not a floating point number " + entry, (Throwable)e);
        }
    }

    protected String doEncode() {
        return this.value.toString();
    }

    protected void doRestore(String data) {
        this.value = new Float(data);
    }

    public void setMask(String mask) {
        this.format = new DecimalFormat(mask);
    }

    public int defaultTypicalLength() {
        return 12;
    }

    public String toString() {
        return "FloatAdapter: " + this.value;
    }
}

