/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.adapter.value.IntegerValue;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public class IntAdapter
extends AbstractValueAdapter
implements IntegerValue {
    private static final NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format;
    private Integer value;

    public IntAdapter() {
        String formatRequired = NakedObjectsContext.getConfiguration().getString("nakedobjects.value.format.int");
        if (formatRequired == null) {
            this.format = DEFAULT_FORMAT;
        } else {
            this.setMask(formatRequired);
        }
    }

    public IntAdapter(Integer value) {
        this();
        this.value = value;
    }

    public String titleString() {
        return this.isEmpty() ? "" : this.format.format(this.value);
    }

    public String getIconName() {
        return "int";
    }

    public Class getValueClass() {
        return Integer.class;
    }

    public Integer integerValue() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean canClear() {
        return true;
    }

    public void clear() {
        this.value = null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    protected void doParse(String entry) {
        try {
            this.value = new Integer(this.format.parse(entry).intValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not an whole number " + entry, (Throwable)e);
        }
    }

    protected String doEncode() {
        return this.value.toString();
    }

    protected void doRestore(String data) {
        this.value = new Integer(data);
    }

    public void setMask(String mask) {
        this.format = new DecimalFormat(mask);
    }

    public int defaultTypicalLength() {
        return 9;
    }

    public String toString() {
        return "IntAdapter: " + this.value;
    }
}

