/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.adapter.value.LongValue;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public class LongAdapter
extends AbstractValueAdapter
implements LongValue {
    private static final NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format = DEFAULT_FORMAT;
    private Long value;

    public LongAdapter() {
        String formatRequired = NakedObjectsContext.getConfiguration().getString("nakedobjects.value.format.long");
        if (formatRequired == null) {
            this.format = DEFAULT_FORMAT;
        } else {
            this.setMask(formatRequired);
        }
    }

    public LongAdapter(Long value) {
        this();
        this.value = value;
    }

    public String titleString() {
        return this.value == null ? "" : this.format.format(this.value);
    }

    public String getIconName() {
        return "long";
    }

    public Class getValueClass() {
        return Long.class;
    }

    public Long longValue() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean canClear() {
        return true;
    }

    public void clear() {
        this.value = null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    protected void doParse(String entry) {
        try {
            this.value = new Long(this.format.parse(entry).longValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not a whole number " + entry, (Throwable)e);
        }
    }

    protected String doEncode() {
        return this.value.toString();
    }

    protected void doRestore(String data) {
        this.value = new Long(data);
    }

    public void setMask(String mask) {
        this.format = new DecimalFormat(mask);
    }

    public int defaultTypicalLength() {
        return 18;
    }

    public String toString() {
        return "LongAdapter: " + this.value;
    }
}

