/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.adapter.value.ShortValue;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public class ShortAdapter
extends AbstractValueAdapter
implements ShortValue {
    private static NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format = DEFAULT_FORMAT;
    private Short value;

    public ShortAdapter() {
        String formatRequired = NakedObjectsContext.getConfiguration().getString("nakedobjects.value.format.short");
        if (formatRequired == null) {
            this.format = DEFAULT_FORMAT;
        } else {
            this.setMask(formatRequired);
        }
    }

    public ShortAdapter(Short value) {
        this();
        this.value = value;
    }

    public String titleString() {
        return this.value == null ? "" : this.format.format(this.value);
    }

    public String getIconName() {
        return "short";
    }

    public Class getValueClass() {
        return Short.class;
    }

    public Short shortValue() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public boolean canClear() {
        return true;
    }

    public void clear() {
        this.value = null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void setValue(Short value) {
        this.value = value;
    }

    protected void doParse(String entry) {
        try {
            this.value = new Short(this.format.parse(entry).shortValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not a whole number " + entry, (Throwable)e);
        }
    }

    protected String doEncode() {
        return this.value.toString();
    }

    protected void doRestore(String data) {
        this.value = new Short(data);
    }

    public void setMask(String mask) {
        this.format = new DecimalFormat(mask);
    }

    public int defaultTypicalLength() {
        return 6;
    }

    public String toString() {
        return "ShortAdapter: " + this.value;
    }
}

