/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.FieldRegEx;
import org.nakedobjects.noa.adapter.value.StringValue;
import org.nakedobjects.nof.core.adapter.value.AbstractValueAdapter;
import org.nakedobjects.nof.core.adapter.value.RegExProcessor;

public class StringAdapter
extends AbstractValueAdapter
implements StringValue {
    private static final int DEFAULT_TYPICAL_LENGTH = 25;
    private String text;
    private String mask;
    private FieldRegEx regEx;

    public StringAdapter() {
        this.text = null;
    }

    public StringAdapter(String text) {
        this.text = text;
    }

    protected String doEncode() {
        if (this.text.equals("NULL") || this.isEscaped(this.text)) {
            return this.escapeText(this.text);
        }
        return this.text;
    }

    private boolean isEscaped(String text) {
        return text.startsWith("/");
    }

    private String escapeText(String text) {
        return "/" + text;
    }

    public boolean canClear() {
        return true;
    }

    public void clear() {
        this.text = null;
    }

    public String getIconName() {
        return "text";
    }

    public Object getObject() {
        return this.text;
    }

    public Class getValueClass() {
        return String.class;
    }

    public boolean isEmpty() {
        return this.text == null || this.text.equals("");
    }

    public boolean isEntryValid(String text) {
        return this.regEx == null || RegExProcessor.isEntryValid(this.regEx, text);
    }

    protected void doParse(String entry) {
        if (this.regEx != null) {
            RegExProcessor.validateEntry(this.regEx, entry);
        }
        this.text = entry.trim().equals("") ? null : entry;
    }

    protected void doRestore(String data) {
        if (this.isEscaped(data)) {
            this.setValue(data.substring(1));
        } else {
            this.setValue(data);
        }
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public void setRegEx(FieldRegEx regEx) {
        this.regEx = regEx;
    }

    public void setValue(String value) {
        this.text = value;
    }

    public String getRegExFormat() {
        return this.regEx == null ? null : this.regEx.getFormatExpression();
    }

    public String getRegExValidation() {
        return this.regEx == null ? null : this.regEx.getValidationExpression();
    }

    public boolean getRegExCaseSensitive() {
        return this.regEx == null ? false : this.regEx.isCaseSensitive();
    }

    public int defaultTypicalLength() {
        return 25;
    }

    public String stringValue() {
        return this.text;
    }

    public String titleString() {
        String string;
        String string2 = string = this.text == null ? "" : this.text;
        if (this.regEx != null && this.regEx.isFormat()) {
            string = RegExProcessor.formatEntry(this.regEx, string);
        }
        if (this.mask != null && this.mask.startsWith("u")) {
            string = string.toUpperCase();
        }
        return string;
    }

    public String toString() {
        return "StringAdapter: " + this.text;
    }
}

