/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.client;

import org.nakedobjects.noa.client.NakedObjectClient;
import org.nakedobjects.noa.security.AuthenticationRequest;
import org.nakedobjects.noa.security.ConnectionManager;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.noa.security.SessionManager;
import org.nakedobjects.nof.core.security.ExplorationSession;

public abstract class AbstractClient
implements NakedObjectClient {
    protected boolean authenticateUser;
    protected ConnectionManager connectionManager;
    protected SessionManager sessionManager;
    protected String title;
    private boolean inExplorationMode;
    private AuthenticationRequest authenticationRequestViaArgs;

    public void setAuthenticationRequestViaArgs(AuthenticationRequest authenticationRequest) {
        this.authenticationRequestViaArgs = authenticationRequest;
    }

    protected abstract AuthenticationRequest promptForAuthenticationDetails();

    protected boolean login() {
        ExplorationSession session;
        if (this.authenticateUser) {
            do {
                AuthenticationRequest request;
                if ((request = this.authenticationRequestViaArgs) == null) {
                    request = this.promptForAuthenticationDetails();
                }
                if (request == null) {
                    return false;
                }
                session = this.sessionManager.authenticate(request);
                this.authenticationRequestViaArgs = null;
            } while (session == null);
        } else {
            session = new ExplorationSession();
        }
        this.connectionManager.connect((Session)session);
        return true;
    }

    public void set_Exploration(boolean inExplorationMode) {
        this.setExploration(inExplorationMode);
    }

    public void set_Title(String title) {
        this.title = title;
    }

    public void setAuthenticate(boolean authenticateUser) {
        this.authenticateUser = authenticateUser;
    }

    public void setExploration(boolean inExplorationMode) {
        this.inExplorationMode = inExplorationMode;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    protected boolean showExplorationMethods() {
        return this.inExplorationMode;
    }

    public void shutdown() {
        this.connectionManager.shutdown();
        System.exit(0);
    }
}

