/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.conf;

import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.conf.PropertiesConfiguration;
import org.nakedobjects.nof.core.conf.PropertiesFileReader;
import org.nakedobjects.nof.core.system.ConfigurationLoader;
import org.nakedobjects.nof.core.util.NakedObjectConfiguration;

public class DefaultConfigurationLoader
implements ConfigurationLoader {
    private static final Logger LOG = Logger.getLogger(DefaultConfigurationLoader.class);
    private static final String DEFAULT_CONFIG_DIR = "config";
    private static final String DEFAULT_CONFIG_FILE = "nakedobjects.properties";
    protected static final String SHOW_EXPLORATION_OPTIONS = "nakedobjects.exploration.show";
    private boolean includeSystemProperties = false;
    private final Properties additionalProperties = new Properties();
    private final PropertiesConfiguration configuration;
    private final String defaultDirectory;

    public DefaultConfigurationLoader() {
        this(DEFAULT_CONFIG_DIR);
    }

    public DefaultConfigurationLoader(String dir) {
        this.defaultDirectory = dir;
        this.configuration = new PropertiesConfiguration();
        this.loadDefaultConfigurationFiles();
    }

    public NakedObjectConfiguration load() {
        if (this.configuration.getString(SHOW_EXPLORATION_OPTIONS) == null) {
            this.configuration.add(SHOW_EXPLORATION_OPTIONS, "yes");
        }
        if (this.includeSystemProperties) {
            this.configuration.add(System.getProperties());
        }
        this.configuration.add(this.additionalProperties);
        return this.configuration;
    }

    public void addConfigurationFile(String dir, String fileName, boolean ensureLoaded) {
        try {
            PropertiesFileReader loader = new PropertiesFileReader(dir, fileName, ensureLoaded);
            if (loader.getFound()) {
                this.configuration.add(loader.getProperties());
            } else {
                this.addConfigurationResource(fileName, ensureLoaded);
            }
        }
        catch (Exception e) {
            this.addConfigurationResource(fileName, ensureLoaded);
        }
    }

    private void addConfigurationResource(String fileName, boolean ensureLoaded) {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Properties p = new Properties();
            URL url = cl.getResource(fileName);
            if (url == null) {
                throw new NakedObjectRuntimeException("Failed to load configuration resource: " + fileName);
            }
            p.load(url.openStream());
            LOG.info((Object)("configuration resource " + fileName + " loaded"));
            this.configuration.add(p);
        }
        catch (Exception e) {
            if (ensureLoaded) {
                throw new NakedObjectRuntimeException((Throwable)e);
            }
            LOG.info((Object)("configuration resource " + fileName + " not found, but not needed"));
        }
    }

    public void addConfigurationFile(String fileName, boolean ensureLoaded) {
        this.addConfigurationFile(this.defaultDirectory, fileName, ensureLoaded);
    }

    public void loadDefaultConfigurationFiles() {
        this.addConfigurationFile(DEFAULT_CONFIG_FILE, true);
    }

    public void setIncludeSystemProperties(boolean includeSystemProperties) {
        this.includeSystemProperties = includeSystemProperties;
    }

    public void add(String property, String value) {
        this.additionalProperties.setProperty(property, value);
        LOG.info((Object)("added " + property + "=" + value));
    }

    public void add(Properties properties) {
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.add(key, properties.getProperty(key));
        }
    }
}

