/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.conf;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.conf.ConfigurationException;
import org.nakedobjects.nof.core.conf.ConfigurationReader;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.NakedObjectConfiguration;

public class PropertiesConfiguration
implements NakedObjectConfiguration {
    private static final Logger LOG = Logger.getLogger(PropertiesConfiguration.class);
    private final String rootPath;
    private final Properties p = new Properties();

    public PropertiesConfiguration() {
        this.rootPath = new File(".").getAbsolutePath();
        LOG.info((Object)("default root path: " + this.rootPath));
    }

    public PropertiesConfiguration(String rootPath) {
        this.rootPath = rootPath;
        LOG.info((Object)("explicit root path: " + rootPath));
    }

    public PropertiesConfiguration(ConfigurationReader loader) {
        this();
        this.add(loader.getProperties());
    }

    public void add(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            this.p.put(name, properties.getProperty(name));
        }
    }

    public void add(String key, String value) {
        if (this.p.containsKey(key)) {
            LOG.info((Object)("replacing " + key + "=" + this.p.get(key) + " with " + value));
        }
        this.p.put(key, value);
    }

    public NakedObjectConfiguration createSubset(String prefix) {
        PropertiesConfiguration subset = new PropertiesConfiguration();
        String startsWith = prefix;
        if (!startsWith.endsWith(".")) {
            startsWith = startsWith + '.';
        }
        int prefixLength = startsWith.length();
        Enumeration<Object> e = this.p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(startsWith)) continue;
            String modifiedKey = key.substring(prefixLength);
            subset.p.put(modifiedKey, this.p.get(key));
        }
        return subset;
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.toLowerCase()).equals("on") || value.equals("yes") || value.equals("true") || value.equals("")) {
            return true;
        }
        if (value.equals("off") || value.equals("no") || value.equals("false")) {
            return false;
        }
        throw new ConfigurationException("Illegal flag for name; must be one of on, off, yes, no, true or false");
    }

    public Color getColor(String name) {
        return this.getColor(name, null);
    }

    public Color getColor(String name, Color defaultValue) {
        String color = this.getProperty(name);
        if (color == null) {
            return defaultValue;
        }
        return Color.decode(color);
    }

    public void debugData(DebugString str) {
        Enumeration<?> names = this.p.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            str.append(name, 55);
            str.append(" = ");
            str.appendln(this.p.getProperty(name));
        }
    }

    public String debugTitle() {
        return "Properties Configuration";
    }

    public Font getFont(String name) {
        return this.getFont(name, null);
    }

    public Font getFont(String name, Font defaultValue) {
        String font = this.getProperty(name);
        if (font == null) {
            return defaultValue;
        }
        return Font.decode(font);
    }

    public int getInteger(String name) {
        return this.getInteger(name, 0);
    }

    public int getInteger(String name, int defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public String[] getList(String name) {
        String list = this.getString(name);
        if (list == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(list, ",");
        String[] array = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            array[i++] = tokens.nextToken().trim();
        }
        return array;
    }

    public NakedObjectConfiguration getProperties(String withPrefix) {
        int prefixLength = "".length();
        Properties pp = new Properties();
        Enumeration<Object> e = this.p.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(withPrefix)) continue;
            String modifiedKey = key.substring(prefixLength);
            pp.put(modifiedKey, this.p.get(key));
        }
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        propertiesConfiguration.add(pp);
        return propertiesConfiguration;
    }

    private String getProperty(String name) {
        return this.getProperty(name, null);
    }

    private String getProperty(String name, String defaultValue) {
        String key = this.referedToAs(name);
        if (key.indexOf("..") >= 0) {
            throw new NakedObjectRuntimeException("property names should not have '..' within them: " + name);
        }
        String property = this.p.getProperty(key, defaultValue);
        LOG.debug((Object)("property: '" + key + "' =  '" + property + "'"));
        return property;
    }

    public String rootPath() {
        return this.rootPath;
    }

    public String getString(String name) {
        return this.getProperty(name);
    }

    public String getString(String name, String defaultValue) {
        return this.getProperty(name, defaultValue);
    }

    public boolean hasProperty(String name) {
        String key = this.referedToAs(name);
        return this.p.containsKey(key);
    }

    public boolean isEmpty() {
        return this.p.isEmpty();
    }

    public Enumeration propertyNames() {
        return this.p.keys();
    }

    private String referedToAs(String name) {
        return name;
    }

    public int size() {
        return this.p.size();
    }

    public String toString() {
        return "ConfigurationParameters [properties=" + this.p + "]";
    }
}

