/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.conf.ConfigurationReader;

public class PropertiesFilesReader
implements ConfigurationReader {
    private Properties properties = new Properties();
    private boolean ensureFileLoads;

    public PropertiesFilesReader(boolean ensureFileLoads) {
        this.ensureFileLoads = ensureFileLoads;
    }

    public PropertiesFilesReader(String pathname, boolean ensureFileLoads) {
        this(ensureFileLoads);
        this.loadProperties(pathname);
    }

    public void loadProperties(String pathname) {
        try {
            File file = new File(pathname);
            FileInputStream in = new FileInputStream(file);
            this.properties.load(in);
        }
        catch (FileNotFoundException e) {
            if (this.ensureFileLoads) {
                throw new NakedObjectRuntimeException("Could not find required configuration file: " + pathname);
            }
        }
        catch (IOException e) {
            throw new NakedObjectRuntimeException("Could not load configuration file: " + pathname, (Throwable)e);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

