/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.conf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.conf.ConfigurationReader;

class PropertiesResourceReader
implements ConfigurationReader {
    private Properties properties = new Properties();

    public PropertiesResourceReader(String pathname, boolean ensureFileLoads) {
        InputStream in = null;
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            in = classLoader.getResourceAsStream(pathname);
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        if (in == null) {
            classLoader = this.getClass().getClassLoader();
            in = classLoader.getResourceAsStream(pathname);
        }
        if (in == null) {
            if (ensureFileLoads) {
                throw new NakedObjectRuntimeException("Cannot find configuration parameters in ClassLoader : " + pathname);
            }
            return;
        }
        try {
            this.properties.load(in);
        }
        catch (IOException e) {
            throw new NakedObjectRuntimeException("Error loading properties for " + pathname + " - " + e.getMessage());
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

