/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.context;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.persist.InstancesCriteria;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.nof.core.context.ContextDebug;
import org.nakedobjects.nof.core.context.Perspective;
import org.nakedobjects.nof.core.context.PerspectiveCriteria;
import org.nakedobjects.nof.core.context.UpdateNotifier;
import org.nakedobjects.nof.core.image.TemplateImageLoader;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.NakedObjectConfiguration;
import org.nakedobjects.object.MessageBroker;

public abstract class NakedObjectsContext
implements DebugInfo {
    private static final Logger LOG = Logger.getLogger(NakedObjectsContext.class);
    private static final boolean DEBUG = false;
    private static NakedObjectsContext singleton;
    private static NakedObjectConfiguration configuration;

    public static void closeSession() {
        NakedObjectsContext instance = NakedObjectsContext.getInstance();
        instance.clearSession();
    }

    public static DebugInfo[] debug() {
        ArrayList<DebugInfo> l = new ArrayList<DebugInfo>();
        l.add(NakedObjectsContext.getInstance());
        l.add(NakedObjectsContext.getConfiguration());
        l.add((DebugInfo)NakedObjectsContext.getReflector());
        l.add((DebugInfo)NakedObjectsContext.getObjectLoader());
        l.add((DebugInfo)NakedObjectsContext.getObjectPersistor());
        return l.toArray(new DebugInfo[l.size()]);
    }

    public void debugData(DebugString debug) {
        debug.appendln("context ", this);
    }

    public static NakedObjectConfiguration getConfiguration() {
        return configuration;
    }

    public static NakedObject getPerspective() {
        String userName = NakedObjectsContext.getSession().getUserName();
        NakedObject perspective = NakedObjectsContext.getPerspective(userName);
        if (perspective == null) {
            return NakedObjectsContext.createPerspective(userName);
        }
        return perspective;
    }

    private static NakedObject getPerspective(String userName) {
        NakedCollection instances = NakedObjectsContext.getObjectPersistor().findInstances((InstancesCriteria)new PerspectiveCriteria(userName));
        if (instances.size() == 0) {
            return null;
        }
        return instances.firstElement();
    }

    private static NakedObject createPerspective(String userName) {
        Perspective perspective = new Perspective();
        NakedObject template = NakedObjectsContext.getPerspective("_template");
        if (template == null) {
            perspective.setName("Naked Objects Exploration");
            perspective.setUserName(userName);
            Object[] services = NakedObjectsContext.getObjectLoader().getServices();
            if (services.length == 0) {
                throw new NakedObjectRuntimeException("No known services");
            }
            for (int i = 0; i < services.length; ++i) {
                perspective.addToServices(services[i]);
            }
            LOG.info((Object)("creating exploration Perspective for " + userName));
        } else {
            String name = ((Perspective)template.getObject()).getName();
            perspective.setName(name);
            perspective.setUserName(userName);
            List services = ((Perspective)template.getObject()).getServices();
            perspective.getServices().addAll(services);
            LOG.info((Object)("creating Perspective, from template, for " + userName));
        }
        NakedObject adapter = NakedObjectsContext.getObjectLoader().createAdapterForTransient((Object)perspective, false);
        NakedObjectsContext.getObjectPersistor().startTransaction();
        NakedObjectsContext.getObjectPersistor().makePersistent(adapter);
        NakedObjectsContext.getObjectPersistor().endTransaction();
        return adapter;
    }

    public static Session getSession() {
        return NakedObjectsContext.getInstance().session();
    }

    public static String getExecutionContextId() {
        return NakedObjectsContext.getInstance().executionContextId();
    }

    public static String[] getAllExecutionContextIds() {
        return NakedObjectsContext.getInstance().allExecutionContextIds();
    }

    public static ContextDebug getDebugContext(String executionContextId) {
        return NakedObjectsContext.getInstance().debugContext(executionContextId);
    }

    public static NakedObjectsContext getInstance() {
        return singleton;
    }

    private static void checkValidState() {
    }

    public static MessageBroker getMessageBroker() {
        return NakedObjectsContext.getInstance().messageBroker();
    }

    public static NakedObjectLoader getObjectLoader() {
        NakedObjectsContext.checkValidState();
        return NakedObjectsContext.getInstance().objectLoader();
    }

    public static NakedObjectPersistor getObjectPersistor() {
        NakedObjectsContext.checkValidState();
        return NakedObjectsContext.getInstance().objectPersistor();
    }

    public static NakedObjectReflector getReflector() {
        NakedObjectsContext.checkValidState();
        return NakedObjectsContext.getInstance().reflector();
    }

    public static TemplateImageLoader getTemplateImageLoader() {
        NakedObjectsContext.checkValidState();
        return NakedObjectsContext.getInstance().templateImageLoader();
    }

    public static UpdateNotifier getUpdateNotifer() {
        NakedObjectsContext.checkValidState();
        return NakedObjectsContext.getInstance().updateNotifier();
    }

    public static boolean isReady() {
        return configuration != null && singleton.reflector() != null && singleton.objectPersistor() != null && singleton.objectLoader() != null && singleton.messageBroker() != null;
    }

    public static void reset() {
        singleton = null;
    }

    protected NakedObjectsContext() {
        NakedObjectsContext.reset();
        if (singleton != null) {
            throw new NakedObjectRuntimeException("Naked Objects Singleton already set up");
        }
        singleton = this;
    }

    protected abstract void terminateSession();

    protected abstract Session session();

    protected abstract UpdateNotifier updateNotifier();

    protected abstract String executionContextId();

    protected abstract String[] allExecutionContextIds();

    protected abstract ContextDebug debugContext(String var1);

    protected abstract MessageBroker messageBroker();

    protected abstract NakedObjectLoader objectLoader();

    protected abstract NakedObjectPersistor objectPersistor();

    public static void setConfiguration(NakedObjectConfiguration configuration) {
        NakedObjectsContext.configuration = configuration;
    }

    public abstract void setObjectLoader(NakedObjectLoader var1);

    public abstract void setObjectPersistor(NakedObjectPersistor var1);

    public abstract void setSession(Session var1);

    public abstract void clearSession();

    public abstract void setReflector(NakedObjectReflector var1);

    public abstract void setTemplateImageLoader(TemplateImageLoader var1);

    protected abstract NakedObjectReflector reflector();

    protected abstract TemplateImageLoader templateImageLoader();

    public static void shutdown() {
        LOG.info((Object)"shutting down");
        NakedObjectsContext instance = NakedObjectsContext.getInstance();
        instance.shutdownSession();
    }

    public abstract void shutdownSession();
}

