/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.context;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.nof.core.context.ContextDebug;
import org.nakedobjects.nof.core.context.SimpleMessageBroker;
import org.nakedobjects.nof.core.context.SimpleUpdateNotifier;
import org.nakedobjects.nof.core.context.UpdateNotifier;
import org.nakedobjects.nof.core.image.TemplateImageLoader;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.object.MessageBroker;

public class NakedObjectsData
implements ContextDebug {
    private static final Logger LOG = Logger.getLogger(NakedObjectsData.class);
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("dd/MM HH:mm:ss,SSS");
    private static int nextId = 1;
    private final int id = nextId++;
    protected NakedObjectLoader objectLoader;
    protected NakedObjectPersistor objectPersistor;
    protected NakedObjectReflector reflector;
    protected MessageBroker messageBroker = new SimpleMessageBroker();
    protected UpdateNotifier updateNotifier = new SimpleUpdateNotifier();
    protected Session session;
    protected TemplateImageLoader templateImageLoader;
    protected long accessTime;
    private String snapshot;

    public String toString() {
        ToString toString = new ToString(this);
        toString.append("context", this.executionContextId());
        toString.append("objectPersistor", this.objectPersistor);
        toString.append("session", this.session);
        toString.append("messageBroker", this.messageBroker);
        toString.append("objectLoader", this.objectLoader);
        toString.append("imageLoader", this.templateImageLoader);
        return toString.toString();
    }

    public String executionContextId() {
        return "#" + this.id + (this.session == null ? "" : "/" + this.session.getUserName());
    }

    public void debug(DebugString debug) {
        debug.appendAsHexln("hash", this.hashCode());
        debug.appendln("context id", this.id);
        debug.appendln("accessed", FORMAT.format(new Date(this.accessTime)));
        debug.appendln("image tmpl", this.templateImageLoader);
        debug.appendln("reflector", this.reflector);
        debug.appendln("loader", this.objectLoader);
        debug.appendln("persistor", this.objectPersistor);
        debug.appendln("updates", this.updateNotifier);
        debug.appendln("message broker", this.messageBroker);
        debug.appendln("session", this.session);
    }

    public void debugAll(DebugString debug) {
        debug.startSection("Naked Objects Context Snapshot");
        debug.appendln(this.snapshot);
        debug.endSection();
    }

    private void debug(DebugString debug, Object object) {
        if (object instanceof DebugInfo) {
            DebugInfo d = (DebugInfo)object;
            debug.startSection(d.debugTitle());
            d.debugData(debug);
            debug.endSection();
        } else {
            debug.appendln("no debug for " + object);
        }
    }

    public void takeSnapshot() {
        DebugString debug = new DebugString();
        this.debug(debug);
        debug.indent();
        debug.appendln();
        this.debug(debug, this.objectLoader);
        this.debug(debug, this.objectPersistor);
        this.debug(debug, this.updateNotifier);
        this.debug(debug, this.messageBroker);
        this.snapshot = debug.toString();
        LOG.debug((Object)this.snapshot);
    }
}

