/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.context;

import java.util.Enumeration;
import java.util.Vector;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.object.MessageBroker;

public class SimpleMessageBroker
implements MessageBroker,
DebugInfo {
    private Vector messages = new Vector();
    private Vector warnings = new Vector();

    public String[] getMessages() {
        return this.convert(this.messages);
    }

    private String[] convert(Vector items) {
        String[] m = new String[items.size()];
        int i = 0;
        Enumeration e = items.elements();
        while (e.hasMoreElements()) {
            m[i++] = e.nextElement().toString();
        }
        items.removeAllElements();
        return m;
    }

    public void debugData(DebugString debug) {
        this.debugArray(debug, "Messages", this.messages);
        this.debugArray(debug, "Warnings", this.messages);
    }

    private void debugArray(DebugString debug, String title, Vector vector) {
        debug.appendln(title);
        debug.indent();
        if (vector.size() == 0) {
            debug.appendln("none");
        } else {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String text = (String)enumeration.nextElement();
                debug.appendln(text);
            }
        }
        debug.unindent();
    }

    public String debugTitle() {
        return "Simple Message Broker";
    }

    public void ensureEmpty() {
        if (this.warnings.size() > 0) {
            throw new NakedObjectRuntimeException("Message broker still has warnings");
        }
        if (this.messages.size() > 0) {
            throw new NakedObjectRuntimeException("Message broker still has messages");
        }
    }

    public String[] getWarnings() {
        return this.convert(this.warnings);
    }

    public void addWarning(String message) {
        this.warnings.addElement(message);
    }

    public void addMessage(String message) {
        this.messages.addElement(message);
    }
}

