/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.context;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.context.UpdateNotifier;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ToString;

public class SimpleUpdateNotifier
implements UpdateNotifier,
DebugInfo {
    private static final Logger LOG = Logger.getLogger(SimpleUpdateNotifier.class);
    private Vector changes = new Vector();
    private Vector disposals = new Vector();

    public synchronized void addChangedObject(NakedObject object) {
        LOG.debug((Object)("mark as dirty " + object));
        if (!this.changes.contains(object)) {
            this.changes.addElement(object);
        }
    }

    public void addDisposedObject(NakedObject object) {
        LOG.debug((Object)("mark as disposed " + object));
        if (!this.disposals.contains(object)) {
            this.disposals.addElement(object);
        }
    }

    public synchronized Enumeration allChangedObjects() {
        Enumeration changedObjects = this.changes.elements();
        if (this.changes.size() > 0) {
            LOG.debug((Object)("dirty objects " + this.changes));
        }
        this.changes = new Vector();
        return changedObjects;
    }

    public synchronized Enumeration allDisposedObjects() {
        Enumeration disposedObjects = this.disposals.elements();
        if (this.disposals.size() > 0) {
            LOG.debug((Object)("disposed objects " + this.disposals));
        }
        this.disposals = new Vector();
        return disposedObjects;
    }

    public void debugData(DebugString debug) {
        debug.appendln("Changes");
        this.debugList(debug, this.changes);
        debug.appendln("Disposals");
        this.debugList(debug, this.disposals);
    }

    private void debugList(DebugString debug, Vector list) {
        debug.indent();
        if (list.size() == 0) {
            debug.appendln("none");
        } else {
            Enumeration enumeration = list.elements();
            while (enumeration.hasMoreElements()) {
                NakedObject adapter = (NakedObject)enumeration.nextElement();
                debug.appendln(adapter.toString());
            }
        }
        debug.unindent();
    }

    public String debugTitle() {
        return "Simple Update Notifier";
    }

    public void ensureEmpty() {
        if (this.changes.size() > 0) {
            throw new NakedObjectRuntimeException("Update notifier still has updates");
        }
    }

    public void init() {
    }

    public void shutdown() {
        LOG.info((Object)("  shutting down " + this));
        this.changes.removeAllElements();
        this.changes = null;
    }

    public String toString() {
        return new ToString(this).append("changes", this.changes).toString();
    }
}

