/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.context;

import org.nakedobjects.noa.adapter.NakedObjectLoader;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.reflect.NakedObjectReflector;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.nof.core.context.ContextDebug;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.SimpleMessageBroker;
import org.nakedobjects.nof.core.context.SimpleUpdateNotifier;
import org.nakedobjects.nof.core.context.UpdateNotifier;
import org.nakedobjects.nof.core.image.TemplateImageLoader;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.object.MessageBroker;

public class StaticContext
extends NakedObjectsContext
implements ContextDebug {
    private MessageBroker messages = new SimpleMessageBroker();
    private UpdateNotifier updateNotifier = new SimpleUpdateNotifier();
    protected NakedObjectLoader objectLoader;
    protected NakedObjectPersistor objectPersistor;
    protected Session session;
    protected NakedObjectReflector reflector;
    protected TemplateImageLoader templateImageLoader;

    public static NakedObjectsContext createInstance() {
        return new StaticContext();
    }

    protected StaticContext() {
    }

    protected void terminateSession() {
        this.session = null;
    }

    public String debugTitle() {
        return "Naked Objects Client Repository";
    }

    public void debug(DebugString debug) {
        debug.appendAsHexln("hash", this.hashCode());
        debug.appendln("image tmpl", this.templateImageLoader);
        debug.appendln("reflector", this.reflector);
        debug.appendln("loader", this.objectLoader);
        debug.appendln("persistor", this.objectPersistor);
        debug.appendln("session", this.session);
    }

    public void debugAll(DebugString debug) {
        this.debug(debug);
        debug.appendln();
        this.debug(debug, this.objectLoader);
        this.debug(debug, this.objectPersistor);
    }

    private void debug(DebugString debug, Object object) {
        if (object instanceof DebugInfo) {
            DebugInfo d = (DebugInfo)object;
            debug.appendTitle(d.debugTitle());
            d.debugData(debug);
        } else {
            debug.appendln("no debug for " + object);
        }
    }

    protected String executionContextId() {
        return "#1" + (this.session == null ? "" : "/" + this.session.getUserName());
    }

    protected String[] allExecutionContextIds() {
        return new String[]{this.executionContextId()};
    }

    protected ContextDebug debugContext(String executionContextId) {
        return this;
    }

    protected MessageBroker messageBroker() {
        return this.messages;
    }

    protected NakedObjectLoader objectLoader() {
        return this.objectLoader;
    }

    protected NakedObjectPersistor objectPersistor() {
        return this.objectPersistor;
    }

    protected Session session() {
        return this.session;
    }

    protected UpdateNotifier updateNotifier() {
        return this.updateNotifier;
    }

    public void set_ObjectLoader(NakedObjectLoader objectLoader) {
        this.setObjectLoader(objectLoader);
    }

    public void set_ObjectPersistor(NakedObjectPersistor objectManager) {
        this.setObjectPersistor(objectManager);
    }

    public void set_SpecificationLoader(NakedObjectReflector specificationLoader) {
        this.setReflector(specificationLoader);
    }

    public void set_TemplateImageLoader(TemplateImageLoader loader) {
        this.setTemplateImageLoader(loader);
    }

    public void setObjectLoader(NakedObjectLoader objectLoader) {
        this.objectLoader = objectLoader;
    }

    public void setObjectPersistor(NakedObjectPersistor objectManager) {
        this.objectPersistor = objectManager;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void clearSession() {
        this.session = null;
    }

    public void setReflector(NakedObjectReflector specificationLoader) {
        this.reflector = specificationLoader;
    }

    public void setTemplateImageLoader(TemplateImageLoader loader) {
        this.templateImageLoader = loader;
    }

    protected NakedObjectReflector reflector() {
        return this.reflector;
    }

    protected TemplateImageLoader templateImageLoader() {
        return this.templateImageLoader;
    }

    public void shutdownSession() {
        if (this.objectLoader != null) {
            this.objectLoader.shutdown();
            this.objectLoader = null;
        }
        if (this.objectPersistor != null) {
            this.objectPersistor.shutdown();
            this.objectPersistor = null;
        }
    }
}

