/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.context;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.context.ContextDebug;
import org.nakedobjects.nof.core.context.MultiUserContext;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.NakedObjectsData;
import org.nakedobjects.nof.core.system.Monitor;
import org.nakedobjects.nof.core.util.DebugString;

public class ThreadContext
extends MultiUserContext {
    private static final Logger LOG = Logger.getLogger(ThreadContext.class);
    private Hashtable threads = new Hashtable();

    public static NakedObjectsContext createInstance() {
        return new ThreadContext();
    }

    protected ThreadContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearThread() {
        Thread thread = Thread.currentThread();
        Hashtable hashtable = this.threads;
        synchronized (hashtable) {
            if (this.threads.get(thread) == null) {
                throw new NakedObjectRuntimeException("Thread not currently registered");
            }
            this.threads.remove(thread);
        }
    }

    public void debugData(DebugString debug) {
        super.debugData(debug);
        debug.appendln();
        debug.appendTitle("Threads based Contexts");
        Enumeration e = this.threads.keys();
        while (e.hasMoreElements()) {
            Thread thread = (Thread)e.nextElement();
            Object data = this.threads.get(thread);
            debug.appendln(thread.toString(), data);
        }
    }

    public String debugTitle() {
        return "Naked Objects (by thread) " + Thread.currentThread().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NakedObjectsData getLocal() {
        NakedObjectsData local;
        Thread thread = Thread.currentThread();
        Hashtable hashtable = this.threads;
        synchronized (hashtable) {
            local = (NakedObjectsData)this.threads.get(thread);
            if (local == null) {
                local = new NakedObjectsData();
                Monitor.addEvent("Context", "New thread using context (count " + this.threads.size() + ")");
                Hashtable hashtable2 = this.threads;
                synchronized (hashtable2) {
                    this.threads.put(thread, local);
                }
                LOG.info((Object)("  creating local " + local + "; now have " + this.threads.size() + " locals"));
            }
        }
        return local;
    }

    protected String[] allExecutionContextIds() {
        String[] ids = new String[this.threads.size()];
        Enumeration e = this.threads.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            Thread thread = (Thread)e.nextElement();
            NakedObjectsData data = (NakedObjectsData)this.threads.get(thread);
            ids[i++] = data.executionContextId();
        }
        return ids;
    }

    protected ContextDebug debugContext(String executionContextId) {
        Enumeration e = this.threads.keys();
        while (e.hasMoreElements()) {
            Thread thread = (Thread)e.nextElement();
            NakedObjectsData data = (NakedObjectsData)this.threads.get(thread);
            if (!data.executionContextId().equals(executionContextId)) continue;
            return data;
        }
        return null;
    }

    protected void terminateSession() {
        this.clearThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownAllSessions() {
        Hashtable hashtable = this.threads;
        synchronized (hashtable) {
            int i = 0;
            Iterator iter = this.threads.entrySet().iterator();
            while (iter.hasNext()) {
                LOG.info((Object)("Shutting down thread: " + i++));
                NakedObjectsData data = (NakedObjectsData)iter.next().getValue();
                if (data.objectPersistor != null) {
                    data.objectPersistor.shutdown();
                    data.objectPersistor = null;
                }
                if (data.objectLoader == null) continue;
                data.objectLoader.shutdown();
                data.objectLoader = null;
            }
        }
    }

    public void shutdownSession() {
        this.shutdownAllSessions();
    }
}

