/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.image.TemplateImage;
import org.nakedobjects.nof.core.image.TemplateImageLoader;
import org.nakedobjects.nof.core.util.AboutNakedObjects;

public class SplashWindow
extends Window
implements Runnable {
    private static final long serialVersionUID = 1L;
    static final Logger LOG = Logger.getLogger(SplashWindow.class);
    private static final String LOGO_TEXT = "Naked Objects";
    private int delay;
    private final Font textFont;
    private final int height;
    private final int textLineHeight;
    private final int titleLineHeight;
    private Image logo;
    private final int PADDING = 9;
    private Frame parent = (Frame)this.getParent();
    private final int width;
    private Font titleFont;
    private int left;
    private Font logoFont;

    public SplashWindow(TemplateImageLoader loader) {
        super(new Frame());
        String imageName = AboutNakedObjects.getImageName();
        TemplateImage templateImage = loader.getTemplateImage(imageName);
        if (templateImage == null) {
            throw new NakedObjectRuntimeException("Failed to find splash image " + imageName);
        }
        this.logo = templateImage.getImage();
        this.textFont = new Font("SansSerif", 0, 10);
        this.titleFont = new Font("SansSerif", 1, 11);
        this.logoFont = new Font("Serif", 0, 36);
        this.textLineHeight = (int)((double)this.getFontMetrics(this.textFont).getHeight() * 0.85);
        this.titleLineHeight = (int)((double)this.getFontMetrics(this.titleFont).getHeight() * 1.2);
        int height = 0;
        int width = 0;
        if (this.logo != null) {
            width = this.logo.getWidth(this);
            height += this.logo.getHeight(this);
        } else {
            FontMetrics metrics = this.getFontMetrics(this.logoFont);
            width = metrics.stringWidth(LOGO_TEXT);
            height = metrics.getHeight();
        }
        height += 9;
        Dimension text = this.textBounds();
        width = Math.max(width, text.width);
        height += text.height;
        height = 9 + height + 9;
        width = 9 + width + 9;
        this.setSize(width, height);
        this.height = height;
        this.width = width;
        this.left = width / 2 - text.width / 2;
        this.setupCenterLocation();
        this.show();
        this.toFront();
    }

    private void setupCenterLocation() {
        Dimension screen = this.getToolkit().getScreenSize();
        int x = screen.width / 2 - this.width / 2;
        if (screen.width / screen.height >= 2) {
            int f = screen.width / screen.height * 2;
            x = screen.width / f - this.width / 2;
        }
        int y = screen.height / 2 - this.width / 2;
        this.setLocation(x, y);
        this.setBackground(Color.white);
    }

    private Dimension textBounds() {
        FontMetrics textMetrics = this.getFontMetrics(this.textFont);
        FontMetrics titleMetrics = this.getFontMetrics(this.titleFont);
        int width = 0;
        int height = 0;
        width = titleMetrics.stringWidth(AboutNakedObjects.getFrameworkName());
        height += this.titleLineHeight;
        width = Math.max(width, textMetrics.stringWidth(AboutNakedObjects.getFrameworkCopyrightNotice()));
        height += this.textLineHeight;
        width = Math.max(width, textMetrics.stringWidth(this.frameworkVersion()));
        height += this.textLineHeight;
        String text = AboutNakedObjects.getApplicationName();
        if (text != null) {
            width = Math.max(width, titleMetrics.stringWidth(text));
            height += this.titleLineHeight;
        }
        if ((text = AboutNakedObjects.getApplicationCopyrightNotice()) != null) {
            width = Math.max(width, textMetrics.stringWidth(text));
            height += this.textLineHeight;
        }
        if ((text = AboutNakedObjects.getApplicationVersion()) != null) {
            width = Math.max(width, textMetrics.stringWidth(text));
            height += this.textLineHeight;
        }
        return new Dimension(width, height);
    }

    public void paint(Graphics g) {
        String applicationName;
        String applicationCopyrightNotice;
        g.setColor(Color.black);
        g.drawRect(0, 0, this.width - 1, this.height - 1);
        if (this.logo != null) {
            g.drawImage(this.logo, 9, 9, this);
        } else {
            g.setFont(this.logoFont);
            FontMetrics fm = g.getFontMetrics();
            g.drawString(LOGO_TEXT, 9, 9 + fm.getAscent());
        }
        int baseline = this.height - 9 - this.getFontMetrics(this.textFont).getDescent();
        g.setFont(this.textFont);
        g.drawString(this.frameworkVersion(), this.left, baseline);
        g.drawString(AboutNakedObjects.getFrameworkCopyrightNotice(), this.left, baseline -= this.textLineHeight);
        g.setFont(this.titleFont);
        g.drawString(AboutNakedObjects.getFrameworkName(), this.left, baseline -= this.textLineHeight);
        baseline -= this.titleLineHeight;
        g.setFont(this.textFont);
        String applicationVersion = AboutNakedObjects.getApplicationVersion();
        if (applicationVersion != null) {
            g.drawString(applicationVersion, this.left, baseline);
            baseline -= this.textLineHeight;
        }
        if ((applicationCopyrightNotice = AboutNakedObjects.getApplicationCopyrightNotice()) != null) {
            g.drawString(applicationCopyrightNotice, this.left, baseline);
            baseline -= this.textLineHeight;
        }
        if ((applicationName = AboutNakedObjects.getApplicationName()) != null) {
            g.setFont(this.titleFont);
            g.drawString(applicationName, this.left, baseline);
        }
    }

    private String frameworkVersion() {
        return AboutNakedObjects.getFrameworkVersion();
    }

    public void removeAfterDelay(int seconds) {
        this.delay = seconds * 1000;
        new Thread(this).start();
    }

    public void removeImmediately() {
        this.hide();
        this.dispose();
        this.parent.dispose();
    }

    public void run() {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeImmediately();
    }
}

