/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.image.java;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import org.apache.log4j.Logger;
import org.nakedobjects.nof.core.image.TemplateImage;

class AwtTemplateImage
implements TemplateImage {
    private static final Logger LOG = Logger.getLogger(AwtTemplateImage.class);
    private Image image;
    private MediaTracker mt = new MediaTracker(new Canvas());

    static AwtTemplateImage create(Image image) {
        if (image == null) {
            return null;
        }
        return new AwtTemplateImage(image);
    }

    private AwtTemplateImage(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getIcon(int height) {
        Image iconImage;
        if (height == this.image.getHeight(null)) {
            iconImage = this.image;
        } else {
            iconImage = this.image.getScaledInstance(-1, height, 4);
            if (iconImage != null) {
                this.mt.addImage(iconImage, 0);
                try {
                    this.mt.waitForAll();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.mt.isErrorAny()) {
                    LOG.error((Object)("failed to create scaled image: " + iconImage + " " + this.mt.getErrorsAny()[0]));
                    this.mt.removeImage(iconImage);
                    iconImage = null;
                } else {
                    this.mt.removeImage(iconImage);
                    LOG.debug((Object)("image " + iconImage + " scaled to " + height));
                }
            }
            if (iconImage == null || iconImage.getWidth(null) == -1) {
                throw new RuntimeException("scaled image! " + iconImage.toString());
            }
        }
        return iconImage;
    }
}

