/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.image.java;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.image.TemplateImage;
import org.nakedobjects.nof.core.image.TemplateImageLoader;
import org.nakedobjects.nof.core.image.java.AwtTemplateImage;

class AwtTemplateImageLoader
implements TemplateImageLoader {
    private static final String[] EXTENSIONS = new String[]{"png", "gif", "jpg", "jpeg"};
    private static final Logger LOG = Logger.getLogger(AwtTemplateImageLoader.class);
    private static final String IMAGE_DIRECTORY = "images";
    private static final String IMAGE_DIRECTORY_PARAM = "nakedobjects.images.image-directory";
    private static final String SEPARATOR = "/";
    private Boolean alsoLoadAsFiles = null;
    protected final MediaTracker mt = new MediaTracker(new Canvas());
    private Hashtable loadedImages = new Hashtable();
    private Vector missingImages = new Vector();
    private String directory;

    AwtTemplateImageLoader() {
    }

    public TemplateImage getTemplateImage(String name) {
        String root;
        String path = this.directory() + name;
        int extensionAt = path.lastIndexOf(46);
        String string = root = extensionAt == -1 ? path : path.substring(0, extensionAt);
        if (this.loadedImages.contains(root)) {
            return (AwtTemplateImage)this.loadedImages.get(root);
        }
        if (this.missingImages.contains(root)) {
            return null;
        }
        return this.loadImage(path, extensionAt, root);
    }

    private TemplateImage loadImage(String path, int extensionAt, String root) {
        LOG.debug((Object)("searching for image " + path));
        Image image = null;
        if (extensionAt >= 0) {
            image = this.load(path);
            return AwtTemplateImage.create(image);
        }
        for (int i = 0; i < EXTENSIONS.length; ++i) {
            image = this.load(root + "." + EXTENSIONS[i]);
            if (image == null) continue;
            return AwtTemplateImage.create(image);
        }
        LOG.debug((Object)("failed to find image for " + path));
        this.missingImages.addElement(root);
        return null;
    }

    private String directory() {
        if (this.directory == null) {
            this.directory = NakedObjectsContext.getConfiguration().getString(IMAGE_DIRECTORY_PARAM, IMAGE_DIRECTORY);
            if (!this.directory.endsWith(SEPARATOR)) {
                this.directory = this.directory.concat(SEPARATOR);
            }
        }
        return this.directory;
    }

    public void init() {
        LOG.info((Object)("images to be loaded from " + this.directory()));
    }

    private Image load(String path) {
        Image image = this.loadAsResource(path);
        if (image == null) {
            if (this.alsoLoadAsFiles == null) {
                this.alsoLoadAsFiles = new Boolean(NakedObjectsContext.getConfiguration().getBoolean("nakedobjects.images.load-images-from-files", true));
            }
            if (this.alsoLoadAsFiles.booleanValue()) {
                image = this.loadAsFile(path);
            }
        }
        return image;
    }

    private Image loadAsFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        Toolkit t = Toolkit.getDefaultToolkit();
        Image image = t.getImage(file.getAbsolutePath());
        if (image != null) {
            this.mt.addImage(image, 0);
            try {
                this.mt.waitForAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mt.isErrorAny()) {
                LOG.error((Object)("found image file but failed to load it: " + file.getAbsolutePath()));
                this.mt.removeImage(image);
                image = null;
            } else {
                this.mt.removeImage(image);
                LOG.info((Object)("image loaded from file: " + file));
            }
        }
        return image;
    }

    protected Image loadAsResource(String path) {
        URL url = AwtTemplateImageLoader.class.getResource(SEPARATOR + path);
        if (url == null) {
            LOG.debug((Object)("not found image in resources: " + url));
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        if (image != null) {
            this.mt.addImage(image, 0);
            try {
                this.mt.waitForAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mt.isErrorAny()) {
                LOG.error((Object)("found image but failed to load it from resources: " + url + " " + this.mt.getErrorsAny()[0]));
                this.mt.removeImage(image);
                image = null;
            } else {
                this.mt.removeImage(image);
                LOG.info((Object)("image loaded from resources: " + url));
            }
        }
        if (image == null || image.getWidth(null) == -1) {
            throw new RuntimeException(image.toString());
        }
        return image;
    }

    public void shutdown() {
    }
}

