/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SnapshotWriter {
    private static final Format FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
    private final PrintStream os;

    public SnapshotWriter(String directoryPath, String baseFileName, String fileExtension, String message) throws IOException {
        File dir = new File(directoryPath == null || directoryPath.length() == 0 ? "." : directoryPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File indexFile = new File(dir, "index.txt");
        Date date = new Date();
        File logFile = new File(dir, baseFileName + FORMAT.format(date) + "." + fileExtension);
        RandomAccessFile index = new RandomAccessFile(indexFile, "rw");
        index.seek(index.length());
        index.writeBytes(logFile.getName() + ": " + message + "\n");
        index.close();
        this.os = new PrintStream(new FileOutputStream(logFile));
    }

    public void appendLog(String details) {
        this.os.println(details);
    }

    public void close() {
        if (this.os != null) {
            this.os.close();
        }
    }
}

