/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nof.core.persist;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.nof.core.context.NakedObjectsContext;

public abstract class AbstractFixtureBuilder {
    private static final Logger LOG = Logger.getLogger(AbstractFixtureBuilder.class);
    protected final Vector fixtures = new Vector();

    public void addFixture(Object fixture) {
        this.fixtures.addElement(fixture);
    }

    public final void installFixtures() {
        NakedObjectPersistor persistor = NakedObjectsContext.getObjectPersistor();
        this.preInstallFixtures(persistor);
        this.installFixtures(persistor, this.getFixtures());
        this.postInstallFixtures(persistor);
        persistor.reset();
        this.fixtures.removeAllElements();
    }

    private void installFixtures(NakedObjectPersistor persistor, Object[] fixtures) {
        for (Object fixture : fixtures) {
            this.installFixture(persistor, fixture);
        }
    }

    private void installFixture(NakedObjectPersistor persistor, Object fixture) {
        NakedObjectsContext.getObjectLoader().initDomainObject(fixture);
        Object[] childFixtures = this.getFixtures(fixture);
        this.installFixtures(persistor, childFixtures);
        try {
            LOG.info((Object)("installing fixture: " + fixture));
            persistor.startTransaction();
            this.installFixture(fixture);
            persistor.endTransaction();
            LOG.info((Object)"fixture installed");
        }
        catch (RuntimeException e) {
            LOG.error((Object)("installing fixture " + fixture.getClass().getName() + " failed; aborting "), (Throwable)e);
            try {
                persistor.abortTransaction();
            }
            catch (Exception e2) {
                LOG.error((Object)"failure during abort", (Throwable)e2);
            }
            throw e;
        }
    }

    protected Object[] getFixtures() {
        return this.fixtures.toArray();
    }

    protected abstract void installFixture(Object var1);

    protected abstract Object[] getFixtures(Object var1);

    protected void postInstallFixtures(NakedObjectPersistor objectManager) {
    }

    protected void preInstallFixtures(NakedObjectPersistor objectManager) {
    }
}

